/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.testcontainers.model;

public class Secret {
    private String name;
    private String description;
    private String username;
    private String password;
    private String token;
    private String tokenHeader;
    private String caCertPem;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getTokenHeader() {
        return this.tokenHeader;
    }

    public void setTokenHeader(String tokenHeader) {
        this.tokenHeader = tokenHeader;
    }

    public String getCaCertPem() {
        return this.caCertPem;
    }

    public void setCaCertPem(String caCertPem) {
        this.caCertPem = caCertPem;
    }

    public static class Builder {
        private String name;
        private String description;
        private String username;
        private String password;
        private String token;
        private String tokenHeader;
        private String caCertPem;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder tokenHeader(String tokenHeader) {
            this.tokenHeader = tokenHeader;
            return this;
        }

        public Builder caCertPem(String caCertPem) {
            this.caCertPem = caCertPem;
            return this;
        }

        public Secret build() {
            Secret secret = new Secret();
            secret.setName(this.name);
            if (this.description != null) {
                secret.setDescription(this.description);
            }
            if (this.username != null) {
                secret.setUsername(this.username);
            }
            if (this.password != null) {
                secret.setPassword(this.password);
            }
            if (this.token != null) {
                secret.setToken(this.token);
            }
            if (this.tokenHeader != null) {
                secret.setTokenHeader(this.tokenHeader);
            }
            if (this.caCertPem != null) {
                secret.setCaCertPem(this.caCertPem);
            }
            return secret;
        }
    }
}

