/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.testcontainers.util.jackson;

import java.io.IOException;
import java.util.ArrayList;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonParser;
import org.testcontainers.shaded.com.fasterxml.jackson.core.JsonToken;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.JsonDeserializer;

public class ArrayToStringDeserializer
extends JsonDeserializer<String> {
    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.currentToken() == JsonToken.START_ARRAY) {
            ArrayList<String> values = new ArrayList<String>();
            jsonParser.nextToken();
            while (jsonParser.hasCurrentToken() && jsonParser.currentToken() != JsonToken.END_ARRAY) {
                if (jsonParser.currentToken() == JsonToken.START_OBJECT) {
                    throw deserializationContext.mappingException("Expected array of primitive types, got an object");
                }
                values.add(jsonParser.getValueAsString());
                jsonParser.nextToken();
            }
            return String.join((CharSequence)",", values);
        }
        return null;
    }
}

