/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.grpc;

import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.util.grpc.GrpcUtil;
import io.grpc.BindableService;
import io.grpc.Status;
import io.grpc.reflection.v1alpha.ErrorResponse;
import io.grpc.reflection.v1alpha.FileDescriptorResponse;
import io.grpc.reflection.v1alpha.ListServiceResponse;
import io.grpc.reflection.v1alpha.ServerReflectionGrpc;
import io.grpc.reflection.v1alpha.ServerReflectionRequest;
import io.grpc.reflection.v1alpha.ServerReflectionResponse;
import io.grpc.reflection.v1alpha.ServiceResponse;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;

public class ProtoReflectionService
extends ServerReflectionGrpc.ServerReflectionImplBase {
    final ServiceRepository serviceRepository;
    final ResourceRepository resourceRepository;

    public ProtoReflectionService(ServiceRepository serviceRepository, ResourceRepository resourceRepository) {
        this.serviceRepository = serviceRepository;
        this.resourceRepository = resourceRepository;
    }

    public static BindableService newInstance(ServiceRepository serviceRepository, ResourceRepository resourceRepository) {
        return new ProtoReflectionService(serviceRepository, resourceRepository);
    }

    public StreamObserver<ServerReflectionRequest> serverReflectionInfo(StreamObserver<ServerReflectionResponse> responseObserver) {
        ServerCallStreamObserver serverCallStreamObserver = (ServerCallStreamObserver)responseObserver;
        ProtoReflectionStreamObserver requestObserver = new ProtoReflectionStreamObserver(this.serviceRepository, this.resourceRepository, (ServerCallStreamObserver<ServerReflectionResponse>)serverCallStreamObserver);
        serverCallStreamObserver.setOnReadyHandler((Runnable)requestObserver);
        serverCallStreamObserver.disableAutoRequest();
        serverCallStreamObserver.request(1);
        return requestObserver;
    }

    private static class ProtoReflectionStreamObserver
    implements Runnable,
    StreamObserver<ServerReflectionRequest> {
        private final ServiceRepository serviceRepository;
        private final ResourceRepository resourceRepository;
        private final ServerCallStreamObserver<ServerReflectionResponse> serverCallStreamObserver;
        private boolean closeAfterSend = false;
        private ServerReflectionRequest request;

        ProtoReflectionStreamObserver(ServiceRepository serviceRepository, ResourceRepository resourceRepository, ServerCallStreamObserver<ServerReflectionResponse> serverCallStreamObserver) {
            this.serviceRepository = serviceRepository;
            this.resourceRepository = resourceRepository;
            this.serverCallStreamObserver = (ServerCallStreamObserver)Preconditions.checkNotNull(serverCallStreamObserver, (Object)"observer");
        }

        @Override
        public void run() {
            if (this.request != null) {
                this.handleReflectionRequest();
            }
        }

        public void onNext(ServerReflectionRequest request) {
            Preconditions.checkState((this.request == null ? 1 : 0) != 0);
            this.request = (ServerReflectionRequest)Preconditions.checkNotNull((Object)request);
            this.handleReflectionRequest();
        }

        public void onCompleted() {
            if (this.request != null) {
                this.closeAfterSend = true;
            } else {
                this.serverCallStreamObserver.onCompleted();
            }
        }

        public void onError(Throwable cause) {
            this.serverCallStreamObserver.onError(cause);
        }

        private void handleReflectionRequest() {
            if (this.serverCallStreamObserver.isReady()) {
                switch (this.request.getMessageRequestCase()) {
                    case FILE_BY_FILENAME: {
                        this.getFileByName(this.request);
                        break;
                    }
                    case FILE_CONTAINING_SYMBOL: {
                        this.getFileContainingSymbol(this.request);
                        break;
                    }
                    case FILE_CONTAINING_EXTENSION: {
                        this.getFileByExtension(this.request);
                        break;
                    }
                    case ALL_EXTENSION_NUMBERS_OF_TYPE: {
                        this.getAllExtensions(this.request);
                        break;
                    }
                    case LIST_SERVICES: {
                        this.listServices(this.request);
                        break;
                    }
                    default: {
                        this.sendErrorResponse(this.request, Status.Code.UNIMPLEMENTED, "not implemented " + this.request.getMessageRequestCase());
                    }
                }
                this.request = null;
                if (this.closeAfterSend) {
                    this.serverCallStreamObserver.onCompleted();
                } else {
                    this.serverCallStreamObserver.request(1);
                }
            }
        }

        private void getFileByName(ServerReflectionRequest request) {
            this.sendErrorResponse(request, Status.Code.UNIMPLEMENTED, "not implemented " + request.getMessageRequestCase());
        }

        private void getFileContainingSymbol(ServerReflectionRequest request) {
            String version;
            String serviceName = request.getFileContainingSymbol();
            Service service = this.serviceRepository.findByNameAndVersion(serviceName, version = this.getVersionFromServiceName(serviceName));
            if (service != null) {
                this.sendFileDescriptorForService(service, request);
            } else {
                service = this.serviceRepository.findByNameAndVersion(serviceName = serviceName.substring(0, serviceName.lastIndexOf(".")), version = this.getVersionFromServiceName(serviceName));
                if (service != null) {
                    this.sendFileDescriptorForService(service, request);
                } else {
                    this.sendErrorResponse(request, Status.Code.NOT_FOUND, "Symbol not found");
                }
            }
        }

        private void sendFileDescriptorForService(Service service, ServerReflectionRequest request) {
            List<Resource> resources = this.resourceRepository.findByServiceIdAndType(service.getId(), ResourceType.PROTOBUF_DESCRIPTOR);
            if (!resources.isEmpty()) {
                Resource resource = resources.get(0);
                String shortServiceName = service.getName();
                if (service.getName().contains(".")) {
                    shortServiceName = service.getName().substring(service.getName().lastIndexOf(".") + 1);
                }
                try {
                    Descriptors.FileDescriptor fd = GrpcUtil.findFileDescriptorBySymbol(resource.getContent(), shortServiceName);
                    this.serverCallStreamObserver.onNext((Object)this.createServerReflectionResponse(request, fd));
                }
                catch (Exception e) {
                    this.sendErrorResponse(request, Status.Code.INTERNAL, "Unreadable protobuf descriptor");
                }
            } else {
                this.sendErrorResponse(request, Status.Code.INTERNAL, "No protobuf descriptor found");
            }
        }

        private void getFileByExtension(ServerReflectionRequest request) {
            this.sendErrorResponse(request, Status.Code.UNIMPLEMENTED, "not implemented " + request.getMessageRequestCase());
        }

        private void getAllExtensions(ServerReflectionRequest request) {
            this.sendErrorResponse(request, Status.Code.UNIMPLEMENTED, "not implemented " + request.getMessageRequestCase());
        }

        private void listServices(ServerReflectionRequest request) {
            ListServiceResponse.Builder builder = ListServiceResponse.newBuilder();
            List<Service> services = this.serviceRepository.findByType(ServiceType.GRPC);
            for (Service service : services) {
                builder.addService(ServiceResponse.newBuilder().setName(service.getName()));
            }
            this.serverCallStreamObserver.onNext((Object)ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setListServicesResponse(builder).build());
        }

        private void sendErrorResponse(ServerReflectionRequest request, Status.Code code, String message) {
            ServerReflectionResponse response = ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setErrorResponse(ErrorResponse.newBuilder().setErrorCode(code.value()).setErrorMessage(message)).build();
            this.serverCallStreamObserver.onNext((Object)response);
        }

        private ServerReflectionResponse createServerReflectionResponse(ServerReflectionRequest request, Descriptors.FileDescriptor fd) {
            FileDescriptorResponse.Builder fdRBuilder = FileDescriptorResponse.newBuilder();
            HashSet<String> seenFiles = new HashSet<String>();
            ArrayDeque<Descriptors.FileDescriptor> frontier = new ArrayDeque<Descriptors.FileDescriptor>();
            seenFiles.add(fd.getName());
            frontier.add(fd);
            while (!frontier.isEmpty()) {
                Descriptors.FileDescriptor nextFd = (Descriptors.FileDescriptor)frontier.remove();
                fdRBuilder.addFileDescriptorProto(nextFd.toProto().toByteString());
                for (Descriptors.FileDescriptor dependencyFd : nextFd.getDependencies()) {
                    if (seenFiles.contains(dependencyFd.getName())) continue;
                    seenFiles.add(dependencyFd.getName());
                    frontier.add(dependencyFd);
                }
            }
            return ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setFileDescriptorResponse(fdRBuilder).build();
        }

        private String getVersionFromServiceName(String serviceName) {
            String packageName = serviceName.substring(0, serviceName.lastIndexOf(46));
            String[] parts = packageName.split("\\.");
            return parts.length > 2 ? parts[parts.length - 1] : packageName;
        }
    }
}

