/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.asyncapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.microcks.domain.EventMessage;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Metadata;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.domain.UnidirectionalEvent;
import io.github.microcks.util.AbstractJsonRepositoryImporter;
import io.github.microcks.util.DispatchCriteriaHelper;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.ReferenceResolver;
import io.github.microcks.util.URIBuilder;
import io.github.microcks.util.asyncapi.AsyncAPICommons;
import io.github.microcks.util.metadata.MetadataExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAPI3Importer
extends AbstractJsonRepositoryImporter
implements MockRepositoryImporter {
    private static final Logger log = LoggerFactory.getLogger(AsyncAPI3Importer.class);
    private static final List<String> VALID_VERBS = Arrays.asList("send", "receive");

    public AsyncAPI3Importer(String specificationFilePath, ReferenceResolver referenceResolver) throws IOException {
        super(specificationFilePath, referenceResolver);
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        ArrayList<Service> result = new ArrayList<Service>();
        Service service = new Service();
        service.setName(this.rootSpecification.path("info").path("title").asText());
        service.setVersion(this.rootSpecification.path("info").path("version").asText());
        service.setType(ServiceType.EVENT);
        if (this.rootSpecification.path("info").has("x-microcks")) {
            Metadata metadata = new Metadata();
            MetadataExtractor.completeMetadata(metadata, this.rootSpecification.path("info").path("x-microcks"));
            service.setMetadata(metadata);
        }
        this.initializeReferencedResources(service);
        service.setOperations(this.extractOperations());
        result.add(service);
        return result;
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        String name = service.getName() + "-" + service.getVersion();
        name = Boolean.TRUE.equals(this.isYaml) ? name + ".yaml" : name + ".json";
        Resource resource = new Resource();
        resource.setName(name);
        resource.setType(ResourceType.ASYNC_API_SPEC);
        results.add(resource);
        resource.setContent(this.rootSpecificationContent);
        results.addAll(this.externalResources);
        return results;
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        ArrayList<Exchange> messageDefs = new ArrayList<Exchange>();
        String defaultContentType = "application/json";
        if (this.rootSpecification.has("defaultContentType")) {
            defaultContentType = this.rootSpecification.get("defaultContentType").asText("application/json");
        }
        Iterator operations = this.rootSpecification.path("operations").fields();
        while (operations.hasNext()) {
            Map.Entry operationEntry = (Map.Entry)operations.next();
            JsonNode operationNode = (JsonNode)operationEntry.getValue();
            String action = operationNode.path("action").asText();
            String operationName = action.toUpperCase() + " " + (String)operationEntry.getKey();
            if (!operationName.equals(operation.getName()) || !operationNode.path("messages").isArray()) continue;
            List<EventMessage> eventMessages = this.buildEventMessages(operationNode, defaultContentType);
            if (eventMessages == null || eventMessages.isEmpty()) break;
            this.completeDispatchingCriteria(operation, operationNode, eventMessages);
            eventMessages.stream().forEach(eventMessage -> messageDefs.add((Exchange)new UnidirectionalEvent(eventMessage)));
            break;
        }
        return messageDefs;
    }

    private List<Operation> extractOperations() {
        ArrayList<Operation> results = new ArrayList<Operation>();
        Iterator operations = this.rootSpecification.path("operations").fields();
        while (operations.hasNext()) {
            Map.Entry operationEntry = (Map.Entry)operations.next();
            String operationShortName = (String)operationEntry.getKey();
            JsonNode operationNode = (JsonNode)operationEntry.getValue();
            String action = operationNode.path("action").asText();
            if (!VALID_VERBS.contains(action)) continue;
            Operation operation = this.buildValidOperation(operationShortName, action, operationNode);
            results.add(operation);
        }
        return results;
    }

    private Operation buildValidOperation(String name, String action, JsonNode operationNode) {
        String operationName = action.toUpperCase() + " " + name;
        Operation operation = new Operation();
        operation.setName(operationName);
        operation.setMethod(action.toUpperCase());
        if (operationNode.has("x-microcks-operation")) {
            MetadataExtractor.completeOperationProperties(operation, operationNode.path("x-microcks-operation"));
        }
        if (operationNode.has("bindings")) {
            AsyncAPICommons.completeOperationLevelBindings(operation, operationNode.get("bindings"));
        }
        if (operationNode.path("channel").isObject()) {
            JsonNode channel = operationNode.get("channel");
            JsonNode channelNode = this.followRefIfAny(channel);
            if (channelNode.has("address")) {
                String address = channelNode.get("address").asText();
                if (AsyncAPICommons.channelAddressHasParts(address)) {
                    operation.setDispatcher("URI_PARTS");
                    operation.setDispatcherRules(DispatchCriteriaHelper.extractPartsFromStringPattern(address));
                }
                operation.addResourcePath(address);
            }
            if (channelNode.has("bindings")) {
                AsyncAPICommons.completeChannelLevelBindings(operation, channelNode.get("bindings"));
            }
        }
        if (operationNode.path("messages").isArray()) {
            Iterator messages = operationNode.path("messages").elements();
            while (messages.hasNext()) {
                JsonNode messageInChannelNode = this.followRefIfAny((JsonNode)messages.next());
                JsonNode messageNode = this.followRefIfAny(messageInChannelNode);
                if (!messageNode.has("bindings")) continue;
                AsyncAPICommons.completeMessageLevelBindings(operation, messageNode.get("bindings"));
            }
        }
        return operation;
    }

    private void completeDispatchingCriteria(Operation operation, JsonNode operationNode, List<EventMessage> eventMessages) {
        if ("URI_PARTS".equals(operation.getDispatcher())) {
            JsonNode channelNode = this.followRefIfAny(operationNode.get("channel"));
            String address = channelNode.get("address").asText();
            List<AsyncAPIParameter> dynamicParameters = this.getDynamicParameters(channelNode);
            Map<String, Map<String, String>> parametersByMessage = this.getParametersByMessage(channelNode);
            ObjectMapper mapper = this.getObjectMapper(true);
            for (EventMessage eventMessage : eventMessages) {
                Map parameterValues = parametersByMessage.getOrDefault(eventMessage.getName(), new HashMap());
                for (AsyncAPIParameter parameter : dynamicParameters) {
                    String parameterValue = null;
                    try {
                        if (parameter.location().startsWith("$message.payload#")) {
                            String location = parameter.location().substring("$message.payload#".length());
                            JsonNode eventMessageRootNode = mapper.readTree(eventMessage.getContent());
                            parameterValue = eventMessageRootNode.at(location).asText();
                        }
                    }
                    catch (Exception e) {
                        log.warn("Failed to extract the location value in {} from message {} for operation {}", new Object[]{parameter.location(), eventMessage.getName(), operation.getName()});
                        log.warn("Pursuing with the other ones but dispatch will be incomplete");
                    }
                    if (parameterValue == null) continue;
                    parameterValues.put(parameter.name(), parameterValue);
                }
                String resourcePath = URIBuilder.buildURIFromPattern(address, parameterValues);
                operation.addResourcePath(resourcePath);
                eventMessage.setDispatchCriteria(DispatchCriteriaHelper.buildFromPartsMap(address, parameterValues));
            }
        }
    }

    private List<AsyncAPIParameter> getDynamicParameters(JsonNode channelNode) {
        ArrayList<AsyncAPIParameter> results = new ArrayList<AsyncAPIParameter>();
        if (channelNode.path("parameters").isObject()) {
            Iterator parameters = channelNode.get("parameters").fields();
            while (parameters.hasNext()) {
                Map.Entry parameterEntry = (Map.Entry)parameters.next();
                JsonNode parameter = this.followRefIfAny((JsonNode)parameterEntry.getValue());
                String parameterName = (String)parameterEntry.getKey();
                if (!parameter.has("location")) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Processing param {} for channel {}, with location {}", new Object[]{parameterName, channelNode.get("address").asText(), parameter.get("location").asText()});
                }
                results.add(new AsyncAPIParameter(parameterName, parameter.get("location").asText()));
            }
        }
        return results;
    }

    private Map<String, Map<String, String>> getParametersByMessage(JsonNode channelNode) {
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>();
        if (channelNode.path("parameters").isObject()) {
            Iterator parameters = channelNode.get("parameters").fields();
            while (parameters.hasNext()) {
                Map.Entry parameterEntry = (Map.Entry)parameters.next();
                JsonNode parameter = this.followRefIfAny((JsonNode)parameterEntry.getValue());
                String parameterName = (String)parameterEntry.getKey();
                if (parameter.has("location") || !parameter.path("examples").isArray()) continue;
                Iterator examples = parameter.get("examples").elements();
                while (examples.hasNext()) {
                    String example = ((JsonNode)examples.next()).asText();
                    if (!example.contains(":")) continue;
                    String exampleKey = example.substring(0, example.indexOf(":"));
                    String exampleValue = example.substring(example.indexOf(":") + 1);
                    Map exampleParams = results.getOrDefault(exampleKey, new HashMap());
                    if (log.isDebugEnabled()) {
                        log.debug("Processing param {} for channel {} for message {}", new Object[]{parameterName, channelNode.get("address").asText(), exampleKey});
                    }
                    exampleParams.put(parameterName, exampleValue);
                    results.put(exampleKey, exampleParams);
                }
            }
        }
        return results;
    }

    private List<EventMessage> buildEventMessages(JsonNode operationNode, String defaultContentType) {
        List<EventMessage> eventMessages = null;
        Iterator messages = operationNode.path("messages").elements();
        while (messages.hasNext()) {
            String messageName;
            JsonNode operationMessageNode = (JsonNode)messages.next();
            JsonNode messageInChannelNode = this.followRefIfAny(operationMessageNode);
            JsonNode messageNode = this.followRefIfAny(messageInChannelNode);
            String contentType = defaultContentType;
            if (messageNode.has("contentType")) {
                contentType = messageNode.path("contentType").asText();
            }
            if ((messageName = operationMessageNode.path("$ref").textValue()) == null || !messageNode.has("examples")) continue;
            messageName = messageName.substring(messageName.lastIndexOf("/") + 1);
            eventMessages = this.buildEventMessageFromExamples(messageName, contentType, messageNode.get("examples"));
        }
        return eventMessages;
    }

    private List<EventMessage> buildEventMessageFromExamples(String messageName, String contentType, JsonNode examplesNode) {
        ArrayList<EventMessage> exchanges = new ArrayList<EventMessage>();
        Iterator examples = examplesNode.elements();
        while (examples.hasNext()) {
            JsonNode exampleNode = (JsonNode)examples.next();
            EventMessage eventMessage = new EventMessage();
            if (exampleNode.has("name")) {
                eventMessage.setName(exampleNode.get("name").asText());
            } else {
                eventMessage.setName(messageName + "-" + (exchanges.size() + 1));
            }
            eventMessage.setMediaType(contentType);
            eventMessage.setContent(this.getExamplePayload(exampleNode));
            List<Header> headers = AsyncAPICommons.getExampleHeaders(exampleNode);
            for (Header header : headers) {
                eventMessage.addHeader(header);
            }
            exchanges.add(eventMessage);
        }
        return exchanges;
    }

    private String getExamplePayload(JsonNode example) {
        if (example.has("payload")) {
            return this.getValueString(example.path("payload"));
        }
        if (example.has("$payloadRef")) {
            String ref = example.path("$payloadRef").asText();
            JsonNode component = this.rootSpecification.at(ref.substring(1));
            return this.getExamplePayload(component);
        }
        return null;
    }

    private record AsyncAPIParameter(String name, String location) {
    }
}

