/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.ai;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.github.microcks.domain.EventMessage;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Parameter;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.domain.UnidirectionalEvent;
import io.github.microcks.util.DispatchCriteriaHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AICopilotHelper {
    private static Logger log = LoggerFactory.getLogger(AICopilotHelper.class);
    protected static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    protected static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    protected static final String OPENAPI_OPERATION_PROMPT_TEMPLATE = "Given the OpenAPI specification below, generate %2$d full examples (request and response) for operation '%1$s' strictly (no sub-path).\n";
    protected static final String GRAPHQL_OPERATION_PROMPT_TEMPLATE = "Given the GraphQL schema below, generate %2$d full examples (request and response) for operation '%1$s' only.\n";
    protected static final String ASYNCAPI_OPERATION_PROMPT_TEMPLATE = "Given the AsyncAPI specification below, generate %2$d full examples for operation '%1$s' only.\n";
    protected static final String GRPC_OPERATION_PROMPT_TEMPLATE = "Given the gRPC protobuf schema below, generate %3$d full examples (request and response) for operation '%2$s' of service '%1$s'.\n";
    protected static final String YAML_FORMATTING_PROMPT = "Use only this YAML format for output (no other text or markdown):\n";
    protected static final String REQUEST_RESPONSE_EXAMPLE_YAML_FORMATTING_TEMPLATE = "- example: %1$d\n  request:\n    url: <request url>\n    headers:\n      accept: application/json\n    body: <request body>\n  response:\n    code: 200\n    headers:\n      content-type: application/json\n    body: <response body>\n";
    protected static final String UNIDIRECTIONAL_EVENT_EXAMPLE_YAML_FORMATTING_TEMPLATE = "- example: %1$d\n  message:\n    headers:\n      <header_name>: <value 1>\n    payload: <message payload>\n";
    protected static final String GRPC_REQUEST_RESPONSE_EXAMPLE_YAML_FORMATTING_TEMPLATE = "- example: %1$d\n  request:\n    body: <request body in JSON>\n  response:\n    body: <response body in JSON>\n";
    private static final String QUERY_NODE = "query";
    private static final String HEADERS_NODE = "headers";
    private static final String VARIABLES_NODE = "variables";

    private AICopilotHelper() {
    }

    protected static String getOpenAPIOperationPromptIntro(String operationName, int numberOfSamples) {
        return String.format(OPENAPI_OPERATION_PROMPT_TEMPLATE, operationName, numberOfSamples);
    }

    protected static String getGraphQLOperationPromptIntro(String operationName, int numberOfSamples) {
        return String.format(GRAPHQL_OPERATION_PROMPT_TEMPLATE, operationName, numberOfSamples);
    }

    protected static String getAsyncAPIOperationPromptIntro(String operationName, int numberOfSamples) {
        return String.format(ASYNCAPI_OPERATION_PROMPT_TEMPLATE, operationName, numberOfSamples);
    }

    protected static String getGrpcOperationPromptIntro(String serviceName, String operationName, int numberOfSamples) {
        return String.format(GRPC_OPERATION_PROMPT_TEMPLATE, serviceName, operationName, numberOfSamples);
    }

    protected static String getRequestResponseExampleYamlFormattingDirective(int numberOfSamples) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < numberOfSamples; ++i) {
            builder.append(String.format(REQUEST_RESPONSE_EXAMPLE_YAML_FORMATTING_TEMPLATE, i + 1));
        }
        return builder.toString();
    }

    protected static String getUnidirectionalEventExampleYamlFormattingDirective(int numberOfSamples) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < numberOfSamples; ++i) {
            builder.append(String.format(UNIDIRECTIONAL_EVENT_EXAMPLE_YAML_FORMATTING_TEMPLATE, i + 1));
        }
        return builder.toString();
    }

    protected static String getGrpcRequestResponseExampleYamlFormattingDirective(int numberOfSamples) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < numberOfSamples; ++i) {
            builder.append(String.format(GRPC_REQUEST_RESPONSE_EXAMPLE_YAML_FORMATTING_TEMPLATE, i + 1));
        }
        return builder.toString();
    }

    protected static List<RequestResponsePair> parseRequestResponseTemplateOutput(Service service, Operation operation, String content) throws Exception {
        ArrayList<RequestResponsePair> results = new ArrayList<RequestResponsePair>();
        JsonNode root = YAML_MAPPER.readTree(AICopilotHelper.sanitizeYamlContent(content));
        if (root.getNodeType() == JsonNodeType.ARRAY) {
            Iterator examples = root.elements();
            while (examples.hasNext()) {
                JsonNode example = (JsonNode)examples.next();
                JsonNode requestNode = example.path("request");
                Request request = new Request();
                JsonNode requestHeadersNode = requestNode.path(HEADERS_NODE);
                request.setHeaders(AICopilotHelper.buildHeaders(requestHeadersNode));
                request.setContent(AICopilotHelper.getRequestContent(requestHeadersNode, requestNode.path("body")));
                String url = requestNode.path("url").asText();
                if (url.contains("?")) {
                    String[] kvPairs;
                    for (String kvPair : kvPairs = url.substring(url.indexOf("?") + 1).split("&")) {
                        String[] kv = kvPair.split("=");
                        Parameter param = new Parameter();
                        param.setName(kv[0]);
                        param.setValue(kv[1]);
                        request.addQueryParameter(param);
                    }
                }
                JsonNode responseNode = example.path("response");
                Response response = new Response();
                JsonNode responseHeadersNode = responseNode.path(HEADERS_NODE);
                response.setHeaders(AICopilotHelper.buildHeaders(responseHeadersNode));
                response.setContent(AICopilotHelper.getResponseContent(responseHeadersNode, responseNode.path("body")));
                response.setMediaType(responseHeadersNode.path("content-type").asText(null));
                response.setStatus(responseNode.path("code").asText("200"));
                response.setFault(response.getStatus().startsWith("4") || response.getStatus().startsWith("5"));
                Object dispatchCriteria = null;
                if ("URI_PARTS".equals(operation.getDispatcher())) {
                    resourcePathPattern = operation.getName().split(" ")[1];
                    dispatchCriteria = DispatchCriteriaHelper.extractFromURIPattern(operation.getDispatcherRules(), resourcePathPattern, url);
                } else if ("URI_PARAMS".equals(operation.getDispatcher())) {
                    dispatchCriteria = DispatchCriteriaHelper.extractFromURIParams(operation.getDispatcherRules(), url);
                } else if ("URI_ELEMENTS".equals(operation.getDispatcher())) {
                    resourcePathPattern = operation.getName().split(" ")[1];
                    dispatchCriteria = DispatchCriteriaHelper.extractFromURIPattern(operation.getDispatcherRules(), resourcePathPattern, url);
                    dispatchCriteria = (String)dispatchCriteria + DispatchCriteriaHelper.extractFromURIParams(operation.getDispatcherRules(), url);
                } else if ("QUERY_ARGS".equals(operation.getDispatcher())) {
                    Map<String, String> variables = AICopilotHelper.getGraphQLVariables(request.getContent());
                    dispatchCriteria = DispatchCriteriaHelper.extractFromParamMap(operation.getDispatcherRules(), variables);
                }
                response.setDispatchCriteria((String)dispatchCriteria);
                if (service.getType() == ServiceType.GRAPHQL) {
                    AICopilotHelper.adaptGraphQLRequestContent(request);
                }
                results.add(new RequestResponsePair(request, response));
            }
        }
        return results;
    }

    protected static List<UnidirectionalEvent> parseUnidirectionalEventTemplateOutput(String content) throws Exception {
        ArrayList<UnidirectionalEvent> results = new ArrayList<UnidirectionalEvent>();
        JsonNode root = YAML_MAPPER.readTree(AICopilotHelper.sanitizeYamlContent(content));
        if (root.getNodeType() == JsonNodeType.ARRAY) {
            Iterator examples = root.elements();
            while (examples.hasNext()) {
                JsonNode example = (JsonNode)examples.next();
                JsonNode message = example.path("message");
                EventMessage event = new EventMessage();
                JsonNode headersNode = message.path(HEADERS_NODE);
                event.setHeaders(AICopilotHelper.buildHeaders(headersNode));
                event.setMediaType("application/json");
                event.setContent(AICopilotHelper.getMessageContent("application/json", message.path("payload")));
                results.add(new UnidirectionalEvent(event));
            }
        }
        return results;
    }

    private static String sanitizeYamlContent(String pseudoYaml) {
        if (!(pseudoYaml = pseudoYaml.trim()).startsWith("-")) {
            String[] lines;
            boolean inYaml = false;
            boolean nextIsYaml = false;
            boolean addPadding = false;
            StringBuilder yaml = new StringBuilder();
            for (String line : lines = pseudoYaml.split("\\r?\\n|\\r")) {
                if (line.startsWith("-")) {
                    inYaml = true;
                }
                if (line.trim().length() == 0) {
                    inYaml = false;
                }
                if (nextIsYaml && !line.startsWith("-")) {
                    inYaml = true;
                    nextIsYaml = false;
                    addPadding = true;
                    yaml.append("- ").append(line).append("\n");
                    continue;
                }
                if (line.startsWith("```")) {
                    if (inYaml) {
                        inYaml = false;
                        nextIsYaml = false;
                        addPadding = false;
                    } else {
                        nextIsYaml = true;
                    }
                }
                if (!inYaml) continue;
                yaml.append(addPadding ? "  " : "").append(line).append("\n");
                nextIsYaml = false;
            }
            return yaml.toString();
        }
        return pseudoYaml;
    }

    private static Set<Header> buildHeaders(JsonNode headersNode) {
        HashSet<Header> headers = new HashSet<Header>();
        Iterator headerNodes = headersNode.fields();
        while (headerNodes.hasNext()) {
            Map.Entry headerNodeEntry = (Map.Entry)headerNodes.next();
            Header header = new Header();
            header.setName((String)headerNodeEntry.getKey());
            header.setValues(Set.of(((JsonNode)headerNodeEntry.getValue()).asText()));
            headers.add(header);
        }
        return headers;
    }

    private static String getRequestContent(JsonNode headersNode, JsonNode bodyNode) throws Exception {
        String contentType = headersNode.path("accept").asText(null);
        return AICopilotHelper.getMessageContent(contentType, bodyNode);
    }

    private static String getResponseContent(JsonNode headersNode, JsonNode bodyNode) throws Exception {
        String contentType = headersNode.path("content-type").asText(null);
        return AICopilotHelper.getMessageContent(contentType, bodyNode);
    }

    private static String getMessageContent(String contentType, JsonNode bodyNode) throws Exception {
        if (!bodyNode.isMissingNode()) {
            if (!(bodyNode.isTextual() || bodyNode.isEmpty() || contentType != null && !contentType.contains("application/json"))) {
                return JSON_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)bodyNode);
            }
            if (bodyNode.isTextual()) {
                return bodyNode.asText();
            }
        }
        return null;
    }

    private static Map<String, String> getGraphQLVariables(String requestContent) throws Exception {
        JsonNode graphQL = JSON_MAPPER.readTree(requestContent);
        if (graphQL.has(VARIABLES_NODE)) {
            JsonNode variablesNode = graphQL.path(VARIABLES_NODE);
            HashMap<String, String> results = new HashMap<String, String>();
            Set elements = variablesNode.properties();
            for (Map.Entry element : elements) {
                results.put((String)element.getKey(), ((JsonNode)element.getValue()).asText());
            }
            return results;
        }
        log.warn("GraphQL request do not contain variables...");
        return new HashMap<String, String>();
    }

    private static void adaptGraphQLRequestContent(Request request) throws Exception {
        String query;
        JsonNode graphQL = JSON_MAPPER.readTree(request.getContent());
        if (graphQL.has(QUERY_NODE) && (query = graphQL.path(QUERY_NODE).asText()).contains("\n")) {
            query = query.replace("\n", "\\n");
            ((ObjectNode)graphQL).put(QUERY_NODE, query);
            request.setContent(JSON_MAPPER.writeValueAsString((Object)graphQL));
        }
    }

    private static JsonNode followRefIfAny(JsonNode spec, JsonNode referencableNode) {
        if (referencableNode.has("$ref")) {
            String ref = referencableNode.path("$ref").asText();
            return AICopilotHelper.getNodeForRef(spec, ref);
        }
        return referencableNode;
    }

    private static JsonNode getNodeForRef(JsonNode spec, String reference) {
        return spec.at(reference.substring(1));
    }

    protected static String removeTokensFromSpec(String specification, String operationName) throws Exception {
        boolean isJson = specification.trim().startsWith("{");
        JsonNode specNode = isJson ? JSON_MAPPER.readTree(specification) : YAML_MAPPER.readTree(specification);
        AICopilotHelper.resolveReferenceAndRemoveTokensInNode(specNode, specNode);
        List<String> specTokenNames = AICopilotHelper.getTokenNames(specNode);
        if (specTokenNames.contains("openapi")) {
            AICopilotHelper.filterOpenAPISpec(specNode, operationName);
        }
        if (specTokenNames.contains("asyncapi")) {
            AICopilotHelper.filterAsyncAPISpec(specNode, operationName);
        }
        if (isJson) {
            return JSON_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)specNode);
        }
        return YAML_MAPPER.writeValueAsString((Object)specNode);
    }

    protected static void resolveReferenceAndRemoveTokensInNode(JsonNode specNode, JsonNode node) {
        JsonNode target = AICopilotHelper.followRefIfAny(specNode, node);
        if (target.getNodeType() == JsonNodeType.OBJECT) {
            if (node.has("$ref")) {
                ((ObjectNode)node).setAll((ObjectNode)target);
                ((ObjectNode)node).remove("$ref");
            }
            if (target.has("examples")) {
                ((ObjectNode)node).remove("examples");
            }
            if (target.has("example")) {
                ((ObjectNode)node).remove("example");
            }
            if (target.has("x-microcks-operation")) {
                ((ObjectNode)node).remove("x-microcks-operation");
            }
            Iterator fields = target.fields();
            while (fields.hasNext()) {
                AICopilotHelper.resolveReferenceAndRemoveTokensInNode(specNode, (JsonNode)((Map.Entry)fields.next()).getValue());
            }
        }
        if (target.getNodeType() == JsonNodeType.ARRAY) {
            Iterator elements = target.elements();
            while (elements.hasNext()) {
                AICopilotHelper.resolveReferenceAndRemoveTokensInNode(specNode, (JsonNode)elements.next());
            }
        }
    }

    protected static void filterOpenAPISpec(JsonNode specNode, String operationName) {
        String[] operationPathName = operationName.split(" ");
        String verb = operationPathName[0].toLowerCase();
        String path = operationPathName[1];
        JsonNode pathsSpec = ((ObjectNode)specNode).get("paths");
        JsonNode pathSpec = ((ObjectNode)pathsSpec).get(path);
        List<String> keysToKeepInRoot = List.of("openapi", "paths", "info");
        List<String> keysToKeepInPaths = List.of(path);
        List<String> keysToKeepInPath = List.of(verb);
        AICopilotHelper.removeTokensInNode(specNode, keysToKeepInRoot);
        AICopilotHelper.removeTokensInNode(pathsSpec, keysToKeepInPaths);
        AICopilotHelper.removeTokensInNode(pathSpec, keysToKeepInPath);
        AICopilotHelper.removeSecurityTokenInNode(pathSpec, verb);
    }

    protected static void filterAsyncAPISpec(JsonNode specNode, String channelName) {
        String[] operationPathName = channelName.split(" ");
        String channel = operationPathName[1];
        JsonNode channelsSpec = ((ObjectNode)specNode).get("channels");
        List<String> keysToKeepInRoot = List.of("asyncapi", "channels", "info");
        List<String> keysToKeepInChannels = List.of(channel);
        AICopilotHelper.removeTokensInNode(specNode, keysToKeepInRoot);
        AICopilotHelper.removeTokensInNode(channelsSpec, keysToKeepInChannels);
    }

    protected static void removeSecurityTokenInNode(JsonNode specNode, String tokenName) {
        JsonNode verbSpec = ((ObjectNode)specNode).get(tokenName);
        if (verbSpec.has("security")) {
            ((ObjectNode)verbSpec).remove("security");
        }
    }

    protected static List<String> getTokenNames(JsonNode specNode) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        Iterator specNodeFieldNames = specNode.fieldNames();
        while (specNodeFieldNames.hasNext()) {
            fieldNames.add((String)specNodeFieldNames.next());
        }
        return fieldNames;
    }

    protected static void removeTokensInNode(JsonNode specNode, List<String> keysToKeep) {
        List<String> fieldNames = AICopilotHelper.getTokenNames(specNode);
        for (String fieldName : fieldNames) {
            if (keysToKeep.contains(fieldName)) continue;
            ((ObjectNode)specNode).remove(fieldName);
        }
    }
}

