/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.microcks.domain.EventMessage;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.Response;
import io.github.microcks.event.ChangeType;
import io.github.microcks.event.ServiceChangeEvent;
import io.github.microcks.repository.EventMessageRepository;
import io.github.microcks.repository.RequestRepository;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.util.IdBuilder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
public class ImportExportService {
    private static Logger log = LoggerFactory.getLogger(ImportExportService.class);
    @Autowired
    private RequestRepository requestRepository;
    @Autowired
    private ResourceRepository resourceRepository;
    @Autowired
    private ResponseRepository responseRepository;
    @Autowired
    private EventMessageRepository eventMessageRepository;
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private ApplicationContext applicationContext;

    public boolean importRepository(String json) {
        ObjectMapper mapper = new ObjectMapper();
        ImportExportModel model = null;
        try {
            model = (ImportExportModel)mapper.readValue(json, ImportExportModel.class);
        }
        catch (Exception e) {
            log.error("Exception while reading json import", (Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info("Retrieve " + model.getServices().size() + " services to import into repository");
            log.info("Retrieve " + model.getResources().size() + " resources to import into repository");
            log.info("Retrieve " + model.getResponses().size() + " responses to import into repository");
            log.info("Retrieve " + model.getRequests().size() + " requests to import into repository");
            if (model.getEventMessages() != null) {
                log.info("Retrieve " + model.getEventMessages().size() + " event messages to import into repository");
            }
        }
        if (model != null) {
            this.serviceRepository.saveAll(model.getServices());
            this.resourceRepository.saveAll(model.getResources());
            this.responseRepository.saveAll(model.getResponses());
            this.requestRepository.saveAll(model.getRequests());
            if (model.getEventMessages() != null) {
                this.eventMessageRepository.saveAll(model.getEventMessages());
            }
            for (io.github.microcks.domain.Service service : model.getServices()) {
                this.publishServiceChangeEvent(service);
            }
            return true;
        }
        return false;
    }

    private void publishServiceChangeEvent(io.github.microcks.domain.Service service) {
        ServiceChangeEvent event = new ServiceChangeEvent(this, service.getId(), ChangeType.UPDATED);
        this.applicationContext.publishEvent((ApplicationEvent)event);
        log.debug("Service change event has been published");
    }

    public String exportRepository(List<String> ids, String format) {
        StringBuilder result = new StringBuilder("{");
        ObjectMapper mapper = new ObjectMapper();
        List services = this.serviceRepository.findByIdIn(ids);
        try {
            String jsonArray = mapper.writeValueAsString((Object)services);
            result.append("\"services\":").append(jsonArray).append(", ");
        }
        catch (Exception e) {
            log.error("Exception while serializing services for export", (Throwable)e);
        }
        List<Resource> resources = this.resourceRepository.findByServiceIdIn(ids);
        try {
            String jsonArray = mapper.writeValueAsString(resources);
            result.append("\"resources\":").append(jsonArray).append(", ");
        }
        catch (Exception e) {
            log.error("Exception while serializing resources for export", (Throwable)e);
        }
        ArrayList<String> operationIds = new ArrayList<String>();
        for (io.github.microcks.domain.Service service : services) {
            for (Operation operation : service.getOperations()) {
                operationIds.add(IdBuilder.buildOperationId((io.github.microcks.domain.Service)service, (Operation)operation));
            }
        }
        List<Request> requests = this.requestRepository.findByOperationIdIn(operationIds);
        List<Response> responses = this.responseRepository.findByOperationIdIn(operationIds);
        List<EventMessage> eventMessages = this.eventMessageRepository.findByOperationIdIn(operationIds);
        try {
            String jsonArray = mapper.writeValueAsString(requests);
            result.append("\"requests\":").append(jsonArray).append(", ");
            jsonArray = mapper.writeValueAsString(responses);
            result.append("\"responses\":").append(jsonArray).append(", ");
            jsonArray = mapper.writeValueAsString(eventMessages);
            result.append("\"eventMessages\":").append(jsonArray);
        }
        catch (Exception e) {
            log.error("Exception while serializing messages for export", (Throwable)e);
        }
        return result.append("}").toString();
    }

    public static class ImportExportModel {
        private List<io.github.microcks.domain.Service> services;
        private List<Resource> resources;
        private List<Request> requests;
        private List<Response> responses;
        private List<EventMessage> eventMessages;

        public List<io.github.microcks.domain.Service> getServices() {
            return this.services;
        }

        public void setServices(List<io.github.microcks.domain.Service> services) {
            this.services = services;
        }

        public List<Resource> getResources() {
            return this.resources;
        }

        public void setResources(List<Resource> resources) {
            this.resources = resources;
        }

        public List<Request> getRequests() {
            return this.requests;
        }

        public void setRequests(List<Request> requests) {
            this.requests = requests;
        }

        public List<Response> getResponses() {
            return this.responses;
        }

        public void setResponses(List<Response> responses) {
            this.responses = responses;
        }

        public List<EventMessage> getEventMessages() {
            return this.eventMessages;
        }

        public void setEventMessages(List<EventMessage> eventMessages) {
            this.eventMessages = eventMessages;
        }
    }
}

