/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.script;

import io.github.microcks.service.StateStore;
import io.github.microcks.util.script.FakeScriptMockRequest;
import io.github.microcks.util.script.HttpHeadersStringToStringsMap;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEngineBinder {
    private static final Logger log = LoggerFactory.getLogger(ScriptEngineBinder.class);

    private ScriptEngineBinder() {
    }

    public static void bindEnvironment(ScriptEngine engine, String requestContent, Map<String, Object> requestContext, StateStore stateStore) {
        ScriptEngineBinder.bindEnvironment(engine, requestContent, requestContext, stateStore, null);
    }

    public static void bindEnvironment(ScriptEngine engine, String requestContent, Map<String, Object> requestContext, StateStore stateStore, HttpServletRequest request) {
        HttpHeadersStringToStringsMap headers = new HttpHeadersStringToStringsMap();
        if (request != null) {
            for (String headerName : Collections.list(request.getHeaderNames())) {
                headers.put(headerName, Collections.list(request.getHeaders(headerName)));
            }
        }
        FakeScriptMockRequest mockRequest = new FakeScriptMockRequest(requestContent, headers);
        mockRequest.setRequest(request);
        Bindings bindings = engine.createBindings();
        bindings.put("mockRequest", (Object)mockRequest);
        bindings.put("log", (Object)log);
        bindings.put("requestContext", (Object)requestContext);
        bindings.put("store", (Object)stateStore);
        engine.setBindings(bindings, 100);
    }

    public static String ensureSoapUICompatibility(String script) {
        if (script.contains("com.eviware.soapui.support.XmlHolder")) {
            return script.replaceAll("com.eviware.soapui.support.XmlHolder", "io.github.microcks.util.soapui.XmlHolder");
        }
        return script;
    }
}

