/*
 * Decompiled with CFR 0.152.
 */
package com.gobrs.async.core.autoconfig;

import com.gobrs.async.core.GobrsAsync;
import com.gobrs.async.core.TaskFlow;
import com.gobrs.async.core.autoconfig.Environment;
import com.gobrs.async.core.autoconfig.GobrsPropertyAutoConfiguration;
import com.gobrs.async.core.cache.GCache;
import com.gobrs.async.core.cache.GCacheManager;
import com.gobrs.async.core.callback.AsyncTaskExceptionInterceptor;
import com.gobrs.async.core.callback.AsyncTaskPostInterceptor;
import com.gobrs.async.core.callback.AsyncTaskPreInterceptor;
import com.gobrs.async.core.callback.DefaultAsyncExceptionInterceptor;
import com.gobrs.async.core.callback.DefaultAsyncTaskPostInterceptor;
import com.gobrs.async.core.callback.DefaultAsyncTaskPreInterceptor;
import com.gobrs.async.core.config.ConfigFactory;
import com.gobrs.async.core.config.ConfigManager;
import com.gobrs.async.core.config.GobrsConfig;
import com.gobrs.async.core.engine.RuleEngine;
import com.gobrs.async.core.engine.RuleParseEngine;
import com.gobrs.async.core.engine.RulePostProcessor;
import com.gobrs.async.core.engine.RuleThermalLoad;
import com.gobrs.async.core.holder.BeanHolder;
import com.gobrs.async.core.threadpool.GobrsAsyncThreadPoolFactory;
import java.util.Map;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.lang.Nullable;

@Configuration
@AutoConfigureAfter(value={GobrsPropertyAutoConfiguration.class})
@ConditionalOnProperty(prefix="gobrs.async.config", value={"enable"}, matchIfMissing=true, havingValue="true")
@Import(value={BeanHolder.class})
@ComponentScan(value={"com.gobrs.async"})
public class GobrsAutoConfiguration {
    protected static final String GOBRS_NAMESPACE = "com.gobrs.async";
    private GobrsConfig gobrsConfig;

    public GobrsAutoConfiguration() {
    }

    public GobrsAutoConfiguration(GobrsConfig gobrsConfig) {
        this.gobrsConfig = gobrsConfig;
    }

    @Bean
    public TaskFlow taskFlow() {
        return new TaskFlow();
    }

    @Bean
    public GobrsAsyncThreadPoolFactory gobrsAsyncThreadPoolFactory(GobrsConfig gobrsConfig) {
        return new GobrsAsyncThreadPoolFactory(gobrsConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={RuleEngine.class})
    public RuleEngine ruleEngine(GobrsConfig gobrsConfig, GobrsAsync gobrsAsync, GCacheManager cacheManager) {
        return new RuleParseEngine(gobrsConfig, gobrsAsync, cacheManager);
    }

    @Bean
    public GCacheManager cacheManager(@Nullable Map<String, GCache<?, ?, ?>> caches) {
        return new GCacheManager(caches);
    }

    @Bean
    public ConfigFactory configFactory(GobrsConfig gobrsConfig) {
        return new ConfigFactory(gobrsConfig);
    }

    @ConditionalOnBean(value={ConfigFactory.class})
    @Bean
    public ConfigManager configManager() {
        return new ConfigManager();
    }

    @Bean
    public RulePostProcessor ruleEnginePostProcessor(ConfigManager configManager) {
        return new RulePostProcessor(configManager);
    }

    @Bean
    public GobrsAsync gobrsAsync() {
        return new GobrsAsync();
    }

    @Bean
    public BeanHolder gobrsSpring() {
        return new BeanHolder();
    }

    @Bean
    @ConditionalOnMissingBean(value={AsyncTaskExceptionInterceptor.class})
    public AsyncTaskExceptionInterceptor asyncExceptionInterceptor() {
        return new DefaultAsyncExceptionInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={AsyncTaskPreInterceptor.class})
    public AsyncTaskPreInterceptor asyncTaskPreInterceptor() {
        return new DefaultAsyncTaskPreInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={AsyncTaskPostInterceptor.class})
    public AsyncTaskPostInterceptor asyncTaskPostInterceptor() {
        return new DefaultAsyncTaskPostInterceptor();
    }

    @Bean
    public RuleThermalLoad ruleThermalLoading() {
        return new RuleThermalLoad();
    }

    static {
        Environment.env();
    }
}

