/*
 * Decompiled with CFR 0.152.
 */
package com.meetsl.scardview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.meetsl.scardview.SCardViewDelegate;
import com.meetsl.scardview.SCardViewImpl;
import com.meetsl.scardview.SRoundRectDrawableWithShadow;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JX\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016JX\u0010 \u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u001c\u0010#\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\b2\n\b\u0001\u0010$\u001a\u0004\u0018\u00010\fH\u0016J(\u0010%\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0012H\u0016J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010)\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010*\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010+\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/meetsl/scardview/SCardViewBaseImpl;", "Lcom/meetsl/scardview/SCardViewImpl;", "()V", "mCornerRect", "Landroid/graphics/RectF;", "createBackground", "Lcom/meetsl/scardview/SRoundRectDrawableWithShadow;", "cardViewDelegate", "Lcom/meetsl/scardview/SCardViewDelegate;", "context", "Landroid/content/Context;", "backgroundColor", "Landroid/content/res/ColorStateList;", "radius", "", "elevation", "maxElevation", "direction", "", "cornerVisibility", "startColor", "endColor", "getBackgroundColor", "cardView", "getElevation", "getMaxElevation", "getMinHeight", "getMinWidth", "getRadius", "getShadowBackground", "initStatic", "", "initialize", "onCompatPaddingChanged", "onPreventCornerOverlapChanged", "setBackgroundColor", "color", "setColors", "shadowStartColor", "shadowEndColor", "setElevation", "setMaxElevation", "setRadius", "setShadowColor", "updatePadding", "SCardView_release"})
public class SCardViewBaseImpl
implements SCardViewImpl {
    private final RectF mCornerRect = new RectF();

    @Override
    public void initStatic() {
        SRoundRectDrawableWithShadow.Companion.setSRoundRectHelper(new SRoundRectDrawableWithShadow.RoundRectHelper(this){
            final /* synthetic */ SCardViewBaseImpl this$0;

            public void drawRoundRect(@NotNull Canvas canvas, @NotNull RectF bounds, float cornerRadius, int cornerVisibility, @NotNull Paint paint) {
                Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
                Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
                Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
                float twoRadius = cornerRadius * (float)2;
                float innerWidth = bounds.width() - twoRadius - 1.0f;
                float innerHeight = bounds.height() - twoRadius - 1.0f;
                if (cornerRadius >= 1.0f) {
                    float roundedCornerRadius = cornerRadius + 0.5f;
                    SCardViewBaseImpl.access$getMCornerRect$p(this.this$0).set(-roundedCornerRadius, -roundedCornerRadius, roundedCornerRadius, roundedCornerRadius);
                    int saved = canvas.save();
                    canvas.translate(bounds.left + roundedCornerRadius, bounds.top + roundedCornerRadius);
                    if (cornerVisibility == 1 || cornerVisibility == 3 || cornerVisibility == 5) {
                        canvas.drawRect(-roundedCornerRadius, -roundedCornerRadius, 0.0f, 0.0f, paint);
                    } else {
                        canvas.drawArc(SCardViewBaseImpl.access$getMCornerRect$p(this.this$0), 180.0f, 90.0f, true, paint);
                    }
                    canvas.translate(innerWidth, 0.0f);
                    canvas.rotate(90.0f);
                    if (cornerVisibility == 2 || cornerVisibility == 3 || cornerVisibility == 6) {
                        canvas.drawRect(-roundedCornerRadius, -roundedCornerRadius, 0.0f, 0.0f, paint);
                    } else {
                        canvas.drawArc(SCardViewBaseImpl.access$getMCornerRect$p(this.this$0), 180.0f, 90.0f, true, paint);
                    }
                    canvas.translate(innerHeight, 0.0f);
                    canvas.rotate(90.0f);
                    if (cornerVisibility == 2 || cornerVisibility == 4 || cornerVisibility == 5) {
                        canvas.drawRect(-roundedCornerRadius, -roundedCornerRadius, 0.0f, 0.0f, paint);
                    } else {
                        canvas.drawArc(SCardViewBaseImpl.access$getMCornerRect$p(this.this$0), 180.0f, 90.0f, true, paint);
                    }
                    canvas.translate(innerWidth, 0.0f);
                    canvas.rotate(90.0f);
                    if (cornerVisibility == 1 || cornerVisibility == 4 || cornerVisibility == 6) {
                        canvas.drawRect(-roundedCornerRadius, -roundedCornerRadius, 0.0f, 0.0f, paint);
                    } else {
                        canvas.drawArc(SCardViewBaseImpl.access$getMCornerRect$p(this.this$0), 180.0f, 90.0f, true, paint);
                    }
                    canvas.restoreToCount(saved);
                    canvas.drawRect(bounds.left + roundedCornerRadius - 1.0f, bounds.top, bounds.right - roundedCornerRadius + 1.0f, bounds.top + roundedCornerRadius, paint);
                    canvas.drawRect(bounds.left + roundedCornerRadius - 1.0f, bounds.bottom - roundedCornerRadius, bounds.right - roundedCornerRadius + 1.0f, bounds.bottom, paint);
                }
                canvas.drawRect(bounds.left, bounds.top + cornerRadius, bounds.right, bounds.bottom - cornerRadius, paint);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @Override
    public void initialize(@NotNull SCardViewDelegate cardView, @NotNull Context context, @NotNull ColorStateList backgroundColor, float radius, float elevation, float maxElevation, int direction, int cornerVisibility, int startColor, int endColor) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)backgroundColor, (String)"backgroundColor");
        SRoundRectDrawableWithShadow background = this.createBackground(cardView, context, backgroundColor, radius, elevation, maxElevation, direction, cornerVisibility, startColor, endColor);
        background.setAddPaddingForCorners(cardView.getPreventCornerOverlap());
        cardView.setCardBackground(background);
        this.updatePadding(cardView);
    }

    private final SRoundRectDrawableWithShadow createBackground(SCardViewDelegate cardViewDelegate, Context context, ColorStateList backgroundColor, float radius, float elevation, float maxElevation, int direction, int cornerVisibility, int startColor, int endColor) {
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return new SRoundRectDrawableWithShadow(cardViewDelegate, resources, backgroundColor, radius, elevation, maxElevation, direction, cornerVisibility, startColor, endColor);
    }

    @Override
    public void updatePadding(@NotNull SCardViewDelegate cardView) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        Rect shadowPadding = new Rect();
        this.getShadowBackground(cardView).getMaxShadowAndCornerPadding(shadowPadding);
        cardView.setMinWidthHeightInternal((int)Math.ceil(this.getMinWidth(cardView)), (int)Math.ceil(this.getMinHeight(cardView)));
        cardView.setShadowPadding(shadowPadding.left, shadowPadding.top, shadowPadding.right, shadowPadding.bottom);
    }

    @Override
    public void onCompatPaddingChanged(@NotNull SCardViewDelegate cardView) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
    }

    @Override
    public void onPreventCornerOverlapChanged(@NotNull SCardViewDelegate cardView) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        this.getShadowBackground(cardView).setAddPaddingForCorners(cardView.getPreventCornerOverlap());
        this.updatePadding(cardView);
    }

    @Override
    public void setBackgroundColor(@NotNull SCardViewDelegate cardView, @androidx.annotation.Nullable @Nullable ColorStateList color2) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        this.getShadowBackground(cardView).setColor(color2);
    }

    @Override
    public void setShadowColor(@NotNull SCardViewDelegate cardView, int startColor, int endColor) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        this.getShadowBackground(cardView).setShadowColor(startColor, endColor);
    }

    @Override
    public void setColors(@NotNull SCardViewDelegate cardView, int backgroundColor, int shadowStartColor, int shadowEndColor) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        this.getShadowBackground(cardView).setColors(backgroundColor, shadowStartColor, shadowEndColor);
    }

    @Override
    @NotNull
    public ColorStateList getBackgroundColor(@NotNull SCardViewDelegate cardView) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        ColorStateList colorStateList = this.getShadowBackground(cardView).getColor();
        if (colorStateList == null) {
            Intrinsics.throwNpe();
        }
        return colorStateList;
    }

    @Override
    public void setRadius(@NotNull SCardViewDelegate cardView, float radius) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        this.getShadowBackground(cardView).setCornerRadius(radius);
        this.updatePadding(cardView);
    }

    @Override
    public float getRadius(@NotNull SCardViewDelegate cardView) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        return this.getShadowBackground(cardView).getCornerRadius();
    }

    @Override
    public void setElevation(@NotNull SCardViewDelegate cardView, float elevation) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        this.getShadowBackground(cardView).setShadowSize(elevation);
    }

    @Override
    public float getElevation(@NotNull SCardViewDelegate cardView) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        return this.getShadowBackground(cardView).getShadowSize();
    }

    @Override
    public void setMaxElevation(@NotNull SCardViewDelegate cardView, float maxElevation) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        this.getShadowBackground(cardView).setMaxShadowSize(maxElevation);
        this.updatePadding(cardView);
    }

    @Override
    public float getMaxElevation(@NotNull SCardViewDelegate cardView) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        return this.getShadowBackground(cardView).getMaxShadowSize();
    }

    @Override
    public float getMinWidth(@NotNull SCardViewDelegate cardView) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        return this.getShadowBackground(cardView).getMinWidth();
    }

    @Override
    public float getMinHeight(@NotNull SCardViewDelegate cardView) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        return this.getShadowBackground(cardView).getMinHeight();
    }

    @Override
    @NotNull
    public SRoundRectDrawableWithShadow getShadowBackground(@NotNull SCardViewDelegate cardView) {
        Intrinsics.checkParameterIsNotNull((Object)cardView, (String)"cardView");
        Drawable drawable = cardView.getCardBackground();
        if (drawable == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.meetsl.scardview.SRoundRectDrawableWithShadow");
        }
        return (SRoundRectDrawableWithShadow)drawable;
    }

    public static final /* synthetic */ RectF access$getMCornerRect$p(SCardViewBaseImpl $this) {
        return $this.mCornerRect;
    }
}

