/*
 * Decompiled with CFR 0.152.
 */
package com.markose.etrade.account;

import com.markose.etrade.account.SecurityTypeEnum;
import com.markose.etrade.account.TransactionGroupingEnum;

public final class TransactionTypeTrades {
    private SecurityTypeEnum securityTypeEnum;
    private String symbol;
    private TransactionGroupingEnum transactionGroupingEnum = TransactionGroupingEnum.TRADES;
    private TradesTransactionType[] tradesTransactionTypes;

    public TransactionTypeTrades() {
    }

    public TransactionTypeTrades(SecurityTypeEnum securityTypeEnum) {
        this.securityTypeEnum = securityTypeEnum;
    }

    public TransactionTypeTrades(SecurityTypeEnum securityTypeEnum, String symbol) {
        this.securityTypeEnum = securityTypeEnum;
        this.symbol = symbol;
    }

    public TransactionTypeTrades(TradesTransactionType ... tradesTransactionTypes) {
        this.tradesTransactionTypes = tradesTransactionTypes;
    }

    public SecurityTypeEnum getSecurityTypeEnum() {
        return this.securityTypeEnum;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getGroupingName() {
        return this.transactionGroupingEnum.getName();
    }

    public String getTransactionNameString() {
        String transactionsNameString = null;
        if (null != this.tradesTransactionTypes) {
            StringBuilder transactionTypeNames = new StringBuilder(32);
            for (TradesTransactionType type : this.tradesTransactionTypes) {
                transactionTypeNames.append(type.getName()).append(',');
            }
            transactionsNameString = transactionTypeNames.deleteCharAt(transactionTypeNames.length() - 1).toString();
        }
        return transactionsNameString;
    }

    public static enum TradesTransactionType {
        ASSIGNMENT("ASSIGNMENT"),
        EXERCISE("EXERCISE"),
        EXPIRATION("EXPIRATION");

        private String name;

        private TradesTransactionType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

