/*
 * Decompiled with CFR 0.152.
 */
package io.github.maritims.node;

import io.github.maritims.PackageJson;
import io.github.maritims.node.NodeConfiguration;
import io.github.maritims.node.NodePaths;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeWrapper {
    private static final Logger log = LoggerFactory.getLogger(NodeWrapper.class);
    private final NodeConfiguration nodeConfiguration;
    protected final String projectSourceCodeDirectory;
    private PackageJson packageJson;

    public NodeWrapper(NodeConfiguration nodeConfiguration, String projectSourceCodeDirectory) {
        this.nodeConfiguration = nodeConfiguration;
        this.projectSourceCodeDirectory = projectSourceCodeDirectory;
    }

    protected String getVersionString() {
        return "node-v" + this.nodeConfiguration.getMajorVersion() + "." + this.nodeConfiguration.getMinorVersion() + "." + this.nodeConfiguration.getPatchVersion() + "-linux-x64";
    }

    private String getFileName() {
        return this.getVersionString() + ".tar.gz";
    }

    public Path getDownloadFilePath() {
        return this.nodeConfiguration.getDownloadDirectory().resolve(this.getFileName());
    }

    protected Path getNodeExe() {
        return this.nodeConfiguration.getExtractionDirectory().resolve(Paths.get(this.getVersionString(), "bin", "node")).toAbsolutePath();
    }

    protected NodePaths getNodePaths() {
        return new NodePaths(this.nodeConfiguration.getExtractionDirectory().resolve(this.getVersionString()));
    }

    public PackageJson getPackageJson() {
        if (this.packageJson == null) {
            this.packageJson = PackageJson.get(this.projectSourceCodeDirectory);
        }
        return this.packageJson;
    }

    public boolean download() {
        InputStream is;
        if (Files.exists(this.getDownloadFilePath(), new LinkOption[0])) {
            log.info("The file '" + this.getDownloadFilePath() + "' already exists. Skipping download.");
            return true;
        }
        if (!Files.exists(this.nodeConfiguration.getDownloadDirectory(), new LinkOption[0])) {
            log.info("The specified download directory '" + this.nodeConfiguration.getDownloadDirectory() + "' does not exist. Attempting to create it.");
            try {
                Files.createDirectories(this.nodeConfiguration.getDownloadDirectory(), new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error("Unable to create directory " + this.nodeConfiguration.getDownloadDirectory(), (Throwable)e);
                return false;
            }
        }
        String url = "https://nodejs.org/dist/v" + this.nodeConfiguration.getMajorVersion() + "." + this.nodeConfiguration.getMinorVersion() + "." + this.nodeConfiguration.getPatchVersion() + "/" + this.getFileName();
        log.info("Downloading " + url);
        try {
            is = new URL(url).openStream();
        }
        catch (IOException e) {
            log.error("Unable to open stream from URL " + url, (Throwable)e);
            return false;
        }
        try {
            Files.copy(is, this.getDownloadFilePath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            log.error("Unable to replace file " + this.getDownloadFilePath(), (Throwable)e);
            return false;
        }
        log.info("Successfully downloaded " + url + " to " + this.getDownloadFilePath());
        return true;
    }

    public boolean extract(boolean verbose) {
        String destinationDirectory;
        TarArchiveEntry tarEntry;
        TarArchiveInputStream tarArchiveInputStream;
        if (!Files.exists(this.getDownloadFilePath(), new LinkOption[0])) {
            log.error("File " + this.getDownloadFilePath() + " does not exist. Skipping extraction.");
            return false;
        }
        if (this.nodeConfiguration.getExtractionDirectory().resolve(Paths.get(this.getVersionString(), new String[0])).toFile().exists()) {
            log.info("Archive has already been extracted. Skipping extraction.");
            return false;
        }
        log.info("Extracting " + this.getDownloadFilePath());
        try {
            InputStream is = Files.newInputStream(this.getDownloadFilePath(), new OpenOption[0]);
            GzipCompressorInputStream gz = new GzipCompressorInputStream(is);
            tarArchiveInputStream = new TarArchiveInputStream((InputStream)gz);
        }
        catch (IOException e) {
            log.error("Unable to get input stream for archive file", (Throwable)e);
            return false;
        }
        try {
            tarEntry = tarArchiveInputStream.getNextTarEntry();
        }
        catch (IOException e) {
            log.error("Unable to get next entry in archive", (Throwable)e);
            return false;
        }
        try {
            destinationDirectory = new File(this.nodeConfiguration.getExtractionDirectory().toString()).getCanonicalPath();
        }
        catch (IOException e) {
            log.error("Unable to get canonical path for extraction destination", (Throwable)e);
            return false;
        }
        while (tarEntry != null) {
            Path path = Paths.get(destinationDirectory, tarEntry.getName());
            File file = new File(path.toString());
            if (tarEntry.isDirectory() && !file.exists() && !file.mkdirs()) {
                log.error("Unable to create directory: " + path + ". Aborting.");
                return false;
            }
            if (verbose) {
                log.info("Extracting " + file.getAbsolutePath());
            }
            if (tarEntry.isFile()) {
                OutputStream os;
                try {
                    if (!file.exists() && !file.createNewFile()) {
                        log.error("Unable to create file: " + path + ". Aborting.");
                        return false;
                    }
                }
                catch (IOException e) {
                    log.error("Unable to create file from archive entry", (Throwable)e);
                    return false;
                }
                if (!file.setExecutable((tarEntry.getMode() & 0x40) > 0)) {
                    log.error("Unable to mark file as executable: " + path + ". Aborting.");
                    return false;
                }
                try {
                    os = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                }
                catch (IOException e) {
                    log.error("Unable to create output stream for file " + file.getAbsolutePath());
                    return false;
                }
                try {
                    IOUtils.copy((InputStream)tarArchiveInputStream, (OutputStream)os);
                }
                catch (IOException e) {
                    log.error("Unable to copy content from archive entry to file input stream", (Throwable)e);
                    return false;
                }
                IOUtils.closeQuietly((Closeable)os);
            }
            try {
                tarEntry = tarArchiveInputStream.getNextTarEntry();
            }
            catch (IOException e) {
                log.error("Unable to move to next archive entry", (Throwable)e);
                return false;
            }
        }
        IOUtils.closeQuietly((Closeable)tarArchiveInputStream);
        return Files.exists(this.nodeConfiguration.getExtractionDirectory().resolve(this.getVersionString()), new LinkOption[0]);
    }

    public abstract boolean run(String var1);
}

