/*
 * Decompiled with CFR 0.152.
 */
package io.github.maritims;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PackageJson {
    private static final Logger log = LoggerFactory.getLogger(PackageJson.class);
    private final Map<String, String> scripts = new HashMap<String, String>();

    private PackageJson() {
    }

    public static PackageJson get(String sourceCodeDirectory) {
        ObjectMapper objectMapper = new ObjectMapper();
        String packageJsonPath = sourceCodeDirectory + "/package.json";
        File file = new File(packageJsonPath);
        if (!file.exists()) {
            log.error(packageJsonPath + " does not exist.");
            return new PackageJson();
        }
        try {
            return (PackageJson)objectMapper.readValue(file, PackageJson.class);
        }
        catch (IOException e) {
            log.error("Unable to deserialize contents of " + packageJsonPath, (Throwable)e);
            return new PackageJson();
        }
    }

    public Map<String, String> getScripts() {
        return this.scripts;
    }
}

