/*
 * Decompiled with CFR 0.152.
 */
package io.github.marceltanuri.security.commons.oauth.token.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import io.github.marceltanuri.security.commons.oauth.token.configuration.TokenCacheConfiguration;
import io.github.marceltanuri.security.commons.oauth.token.internal.TokenCacheService;
import io.github.marceltanuri.security.commons.oauth.token.internal.TokenResponse;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"io.github.marceltanuri.security.commons.oauth.token.configuration.TokenCacheConfiguration"}, immediate=true, service={TokenCacheService.class})
public class InMemoryTokenCacheService
implements TokenCacheService {
    private Map<String, TokenResponse> _cache;
    private volatile TokenCacheConfiguration _tokenCacheConfiguration;

    @Override
    public TokenResponse get(String key) {
        TokenResponse token = this._cache.get(key);
        if (token != null && token.isValid()) {
            return token;
        }
        this._cache.remove(key);
        return null;
    }

    @Override
    public void put(String key, TokenResponse token) {
        this._cache.put(key, token);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._tokenCacheConfiguration = (TokenCacheConfiguration)ConfigurableUtil.createConfigurable(TokenCacheConfiguration.class, properties);
        final int maxEntries = this._tokenCacheConfiguration.maxEntries();
        this._cache = Collections.synchronizedMap(new LinkedHashMap<String, TokenResponse>(maxEntries, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, TokenResponse> eldest) {
                return this.size() > maxEntries;
            }
        });
    }
}

