/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi.indicators;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.wang.avi.Indicator;
import java.util.ArrayList;

public class LineScaleIndicator
extends Indicator {
    public static final float SCALE = 1.0f;
    float[] scaleYFloats = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float translateX = this.getWidth() / 11;
        float translateY = this.getHeight() / 2;
        for (int i = 0; i < 5; ++i) {
            canvas.save();
            canvas.translate((float)(2 + i * 2) * translateX - translateX / 2.0f, translateY);
            canvas.scale(1.0f, this.scaleYFloats[i]);
            RectF rectF = new RectF(-translateX / 2.0f, (float)(-this.getHeight()) / 2.5f, translateX / 2.0f, (float)this.getHeight() / 2.5f);
            canvas.drawRoundRect(rectF, 5.0f, 5.0f, paint);
            canvas.restore();
        }
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        long[] delays = new long[]{100L, 200L, 300L, 400L, 500L};
        for (int i = 0; i < 5; ++i) {
            final int index = i;
            ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.4f, 1.0f});
            scaleAnim.setDuration(1000L);
            scaleAnim.setRepeatCount(-1);
            scaleAnim.setStartDelay(delays[i]);
            this.addUpdateListener(scaleAnim, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    LineScaleIndicator.this.scaleYFloats[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    LineScaleIndicator.this.postInvalidate();
                }
            });
            animators.add(scaleAnim);
        }
        return animators;
    }
}

