/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.server.api;

import io.github.ma1uta.matrix.common.ErrorResponse;
import io.github.ma1uta.matrix.server.model.federation.EventContainer;
import io.github.ma1uta.matrix.server.model.federation.InviteV2Request;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/federation/v2")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface FederationV2Api {
    @Operation(summary="Invites a remote user to a room.", description="Once the event has been signed by both the inviting homeserver and the invited homeserver, it can be sent to all of the servers in the room by the inviting homeserver. This endpoint is preferred over the v1 API as it is more useful for servers. Senders which receive a 400 or 404 response to this endpoint should retry using the v1 API as the server may be older, if the room version is \"1\" or \"2\". Note that events have a different format depending on the room version-check the room version specification for precise event formats.The request and response bodies here describe the common event fields in more detail and may be missing other required fields for a PDU.", responses={@ApiResponse(responseCode="200", description="The event with the invited server's signature added. All other fields of the events should remain untouched. Note that events have a different format depending on the room version - check the room version specification for precise event formats.", content={@Content(array=@ArraySchema(schema=@Schema(anyOf={Integer.class, EventContainer.class})))}), @ApiResponse(responseCode="403", description="The invite is not allowed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/invite/{roomId}/{eventId}")
    public void invite(@Parameter(name="roomId", description="The room ID that the user is being invited to.", required=true) @PathParam(value="roomId") String var1, @Parameter(name="eventId", description="The event ID for the invite event, generated by the inviting server.", required=true) @PathParam(value="eventId") String var2, @RequestBody InviteV2Request var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6);
}

