/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.server.api;

import io.github.ma1uta.matrix.common.EmptyResponse;
import io.github.ma1uta.matrix.common.ErrorResponse;
import io.github.ma1uta.matrix.server.model.federation.DeviceResponse;
import io.github.ma1uta.matrix.server.model.federation.DirectoryResponse;
import io.github.ma1uta.matrix.server.model.federation.EventContainer;
import io.github.ma1uta.matrix.server.model.federation.InviteV1Request;
import io.github.ma1uta.matrix.server.model.federation.KeyClaimRequest;
import io.github.ma1uta.matrix.server.model.federation.KeyClaimResponse;
import io.github.ma1uta.matrix.server.model.federation.KeyQueryRequest;
import io.github.ma1uta.matrix.server.model.federation.KeyQueryResponse;
import io.github.ma1uta.matrix.server.model.federation.MakeResponse;
import io.github.ma1uta.matrix.server.model.federation.OnBindRequest;
import io.github.ma1uta.matrix.server.model.federation.PersistedDataUnit;
import io.github.ma1uta.matrix.server.model.federation.ProfileResponse;
import io.github.ma1uta.matrix.server.model.federation.PublicRoomsResponse;
import io.github.ma1uta.matrix.server.model.federation.RoomStateResponse;
import io.github.ma1uta.matrix.server.model.federation.SendRequest;
import io.github.ma1uta.matrix.server.model.federation.StateIdResponse;
import io.github.ma1uta.matrix.server.model.federation.StateResponse;
import io.github.ma1uta.matrix.server.model.federation.ThirdPartyInvite;
import io.github.ma1uta.matrix.server.model.federation.Transaction;
import io.github.ma1uta.matrix.server.model.federation.UserInfoResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/federation/v1")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface FederationV1Api {
    @Operation(summary="Push messages representing live activity to another server.", description="The destination name will be set to that of the receiving server itself. Each embedded PDU in the transaction body will be processed.", responses={@ApiResponse(responseCode="200", description="The result of processing the transaction. The server is to use this response even in the event of one or more PDUs failing to be processed.", content={@Content(schema=@Schema(implementation=List.class))})})
    @PUT
    @Path(value="/send/{txnId}")
    public void send(@Parameter(name="transactionId", description="The transaction ID.") @PathParam(value="txnId") String var1, @RequestBody Transaction var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5);

    @Operation(summary="Retrieves the complete auth chain for a given event.", responses={@ApiResponse(responseCode="200", description="The auth chain for the event.", content={@Content(schema=@Schema(implementation=List.class))})})
    @GET
    @Path(value="/event_auth/{roomId}/{eventId}")
    public void eventAuth(@Parameter(name="roomId", description="The room ID to get the auth chain for.", required=true) @PathParam(value="roomId") String var1, @Parameter(name="eventId", description="The event ID to get the auth chain of.", required=true) @PathParam(value="eventId") String var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5);

    @Operation(summary="Retrieves a sliding-window history of previous PDUs that occurred on the given room.", description="Starting from the PDU ID(s) given in the \"v\" argument, the PDUs that preceded it are retrieved, up to a total number given by the \"limit\".", responses={@ApiResponse(responseCode="200", description="A transaction containing the PDUs that preceded the given event(s), including the given event(s), up to the given limit.", content={@Content(schema=@Schema(implementation=Transaction.class))})})
    @GET
    @Path(value="/backfill/{roomId}")
    public void backfill(@Parameter(name="roomId", description="The room ID to backfill.", required=true) @PathParam(value="roomId") String var1, @Parameter(name="v", description="The event IDs to backfill from.", required=true) @QueryParam(value="v") String var2, @Parameter(name="limit", description="The maximum number of PDUs to retrieve, including the given events.", required=true) @QueryParam(value="limit") Long var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6);

    @Operation(summary="Retrieves previous events that the sender is missing.", description="This is done by doing a breadth-first walk of the prev_events for the latest_events, ignoring any events in earliest_events and stopping at the limit.", responses={@ApiResponse(responseCode="200", description="The previous events for latest_events, excluding any earliest_events, up to the provided limit.", content={@Content(schema=@Schema(implementation=List.class))})})
    @POST
    @Path(value="/get_missing_events/{roomId}")
    public void getMissingEvents(@Parameter(name="roomId", description="The room ID to search in.", required=true) @PathParam(value="roomId") String var1, @Parameter(name="limit", description="The maximum number of events to retrieve.", schema=@Schema(defaultValue="10")) @QueryParam(value="limit") Integer var2, @Parameter(name="min_depth", description="The minimum depth of events to retrieve.", schema=@Schema(defaultValue="0")) @QueryParam(value="min_depth") Integer var3, @Parameter(name="earliest_events", description="The latest event IDs that the sender already has. These are skipped when retrieving the previous events of latest_events.", required=true) @QueryParam(value="earliest_events") List<String> var4, @Parameter(name="latest_events", description="The event IDs to retrieve the previous events for.", required=true) @QueryParam(value="latest_events") List<String> var5, @Context UriInfo var6, @Context HttpHeaders var7, @Suspended AsyncResponse var8);

    @Operation(summary="Retrieves a snapshot of a room's state at a given event.", responses={@ApiResponse(responseCode="200", description="The fully resolved state for the room, prior to considering any state changes induced by the requested event. Includes the authorization chain for the events.", content={@Content(schema=@Schema(implementation=StateResponse.class))})})
    @GET
    @Path(value="/state/{roomId}")
    public void state(@Parameter(name="roomId", description="The room ID to get state for.", required=true) @PathParam(value="roomId") String var1, @Parameter(name="event_id", description="An event ID in the room to retrieve the state at.", required=true) @QueryParam(value="event_id") String var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5);

    @Operation(summary="Retrieves a snapshot of a room's state at a given event, in the form of event IDs.", responses={@ApiResponse(responseCode="200", description="The fully resolved state for the room, prior to considering any state changes induced by the requested event. Includes the authorization chain for the events.", content={@Content(schema=@Schema(implementation=StateIdResponse.class))})})
    @GET
    @Path(value="/state_ids/{roomId}")
    public void stateIds(@Parameter(name="roomId", description="The room ID to get state for.", required=true) @PathParam(value="roomId") String var1, @Parameter(name="event_id", description="An event ID in the room to retrieve the state at.", required=true) @QueryParam(value="event_id") String var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5);

    @Operation(summary="Retrieves a single event.", responses={@ApiResponse(responseCode="200", description="A transaction containing a single PDU which is the event requested.", content={@Content(schema=@Schema(implementation=PersistedDataUnit.class))})})
    @GET
    @Path(value="/event/{eventId}")
    public void event(@Parameter(name="eventId", description="The event ID to get.", required=true) @PathParam(value="eventId") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Asks the receiving server to return information that the sending server will need to prepare a join event to get into the room.", responses={@ApiResponse(responseCode="200", description="A template to be used for the rest of the Joining Rooms handshake. Note that events have a different format depending on the room version - check the room version specification for precise event formats. The response body here describes the common event fields in more detail and may be missing other required fields for a PDU.", content={@Content(schema=@Schema(implementation=MakeResponse.class))}), @ApiResponse(responseCode="400", description="The request is invalid or the room the server is attempting to join has a version that is not listed in the ver parameters. The error should be passed through to clients so that they may give better feedback to users.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/make_join/{roomId}/{userId}")
    public void makeJoin(@Parameter(name="roomId", description="The room ID that is about to be joined.", required=true) @PathParam(value="roomId") String var1, @Parameter(name="userId", description="The user ID the join event will be for.", required=true) @PathParam(value="userId") String var2, @Parameter(name="ver", description="The room versions the sending server has support for.", schema=@Schema(defaultValue="1")) @QueryParam(value="ver") List<String> var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6);

    @Operation(summary="Submits a signed join event to the resident server for it to accept it into the room's graph.", description="Note that events have a different format depending on the room version - check the room version specification for precise event formats. The request and response body here describes the common event fields in more detail and may be missing other required fields for a PDU.", responses={@ApiResponse(responseCode="200", description="The full state for the room, having accepted the join event.", content={@Content(array=@ArraySchema(schema=@Schema(anyOf={Integer.class, RoomStateResponse.class})))}), @ApiResponse(responseCode="400", description="The request is invalid or the room the server is attempting to join has a version that is not listed in the ver parameters. The error should be passed through to clients so that they may give better feedback to users.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/send_join/{roomId}/{eventId}")
    public void sendJoin(@Parameter(name="roomId", description="The room ID that is about to be joined.", required=true) @PathParam(value="roomId") String var1, @Parameter(name="eventId", description="The event ID for the join event.", required=true) @PathParam(value="eventId") String var2, @RequestBody SendRequest var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6);

    @Operation(summary="Invites a remote user to a room.", description="Once the event has been signed by both the inviting homeserver and the invited homeserver, it can be sent to all of the servers in the room by the inviting homeserver. Servers should prefer to use the v2 API for invites instead of the v1 API. Servers which receive a v1 invite request must assume that the room version is either \"1\" or \"2\". Note that events have a different format depending on the room version-check the room version specification for precise event formats.The request and response bodies here describe the common event fields in more detail and may be missing other required fields for a PDU.", responses={@ApiResponse(responseCode="200", description="The event with the invited server's signature added. All other fields of the events should remain untouched. Note that events have a different format depending on the room version - check the room version specification for precise event formats.", content={@Content(array=@ArraySchema(schema=@Schema(anyOf={Integer.class, EventContainer.class})))}), @ApiResponse(responseCode="403", description="The invite is not allowed.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @PUT
    @Path(value="/invite/{roomId}/{eventId}")
    public void invite(@Parameter(name="roomId", description="The room ID that the user is being invited to.", required=true) @PathParam(value="roomId") String var1, @Parameter(name="eventId", description="The event ID for the invite event, generated by the inviting server.", required=true) @PathParam(value="eventId") String var2, @RequestBody InviteV1Request var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6);

    @Operation(summary="Asks the receiving server to return information that the sending server will need to prepare a leave event to get out of the room.", responses={@ApiResponse(responseCode="200", description="A template to be used to call /send_leave. Note that events have a different format depending on the room version - check the room version specification for precise event formats. The response body here describes the common event fields in more detail and may be missing other required fields for a PDU.", content={@Content(array=@ArraySchema(schema=@Schema(anyOf={Integer.class, MakeResponse.class})))}), @ApiResponse(responseCode="403", description="The request is not authorized. This could mean that the user is not in the room.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/make_leave/{roomId}/{userId}")
    public void makeLeave(@Parameter(name="roomId", description="The room ID that is about to be left.", required=true) @PathParam(value="roomId") String var1, @Parameter(name="userId", description="The user ID the leave event will be for.", required=true) @PathParam(value="userId") String var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5);

    @Operation(summary="Submits a signed leave event to the resident server for it to accept it into the room's graph.", description="Note that events have a different format depending on the room version - check the room version specification for precise event formats. The request and response body here describes the common event fields in more detail and may be missing other required fields for a PDU.", responses={@ApiResponse(responseCode="200", description="An empty response to indicate the event was accepted into the graph by the receiving homeserver.", content={@Content(array=@ArraySchema(schema=@Schema(anyOf={Integer.class, EmptyResponse.class})))})})
    @PUT
    @Path(value="/send_leave/{roomId}/{eventId}")
    public void sendLeave(@Parameter(name="roomId", description="The room ID that is about to be left.", required=true) @PathParam(value="roomId") String var1, @Parameter(name="eventId", description="The event ID for the leave event.", required=true) @PathParam(value="eventId") String var2, @RequestBody SendRequest var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6);

    @Operation(summary="The receiving server will verify the partial m.room.member event given in the request body.", description="If valid, the receiving server will issue an invite as per the Inviting to a room section before returning a response to this request.", responses={@ApiResponse(responseCode="200", description="The invite has been issued successfully.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})})
    @PUT
    @Path(value="/exchange_third_party_invite/{roomId}")
    public void exchangeThirdPartyInvite(@Parameter(name="roomId", description="The room ID to exchange a third party invite in.", required=true) @PathParam(value="roomId") String var1, @RequestBody ThirdPartyInvite var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5);

    @Operation(summary="Used by identity servers to notify the homeserver that one of its users has bound a third party identifier successfully, including any pending room invites the identity server has been made aware of.", responses={@ApiResponse(responseCode="200", description="The homeserver has processed the notification.", content={@Content(schema=@Schema(implementation=EmptyResponse.class))})})
    @Path(value="/3pid/onbind")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void onBind(@RequestBody OnBindRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Gets all the public rooms for the homeserver.", description="This should not return rooms that are listed on another homeserver's directory, just those listed on the receiving homeserver's directory.", responses={@ApiResponse(responseCode="200", description="The public room list for the homeserver.", content={@Content(schema=@Schema(implementation=PublicRoomsResponse.class))})})
    @GET
    @Path(value="/publicRooms")
    public void publicRooms(@Parameter(name="limit", description="The maximum number of rooms to return.", schema=@Schema(defaultValue="0")) @QueryParam(value="limit") Integer var1, @Parameter(name="since", description="A pagination token from a previous call to this endpoint to fetch more rooms.") @QueryParam(value="since") String var2, @Parameter(name="include_all_networks", description="Whether or not to include all networks/protocols defined by application services on the homeserver", schema=@Schema(defaultValue="false")) @QueryParam(value="include_all_networks") Boolean var3, @Parameter(name="third_party_instance_id", description="The specific third party network/protocol to request from the homeserver. Can only be used if include_all_networks is false.") @QueryParam(value="third_party_instance_id") String var4, @Context UriInfo var5, @Context HttpHeaders var6, @Suspended AsyncResponse var7);

    @Operation(summary="Performs a query to get the mapped room ID and list of resident homeservers in the room for a given room alias.", description="Servers may wish to cache the response to this query to avoid requesting the information too often.", responses={@ApiResponse(responseCode="200", description="The corresponding room ID and list of known resident homeservers for the room.", content={@Content(schema=@Schema(implementation=DirectoryResponse.class))}), @ApiResponse(responseCode="404", description="The room alias was not found.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/query/directory")
    public void queryDirectory(@Parameter(name="room_alias", description="The room alias to query.", required=true) @QueryParam(value="room_alias") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Performs a query to get profile information, such as a display name or avatar, for a given user.", description=" Homeservers should only query profiles for users that belong to the target server (identified by the DNS Name in the user ID). Servers may wish to cache the response to this query to avoid requesting the information too often.", responses={@ApiResponse(responseCode="200", description="The profile for the user. If a field is specified in the request, only the matching field should be included in the response. If no field was specified, the response should include the fields of the user's profile that can be made public, such as the display name and avatar.If the user does not have a particular field set on their profile, the server should exclude it from the response body or give it the value null.", content={@Content(schema=@Schema(implementation=ProfileResponse.class))}), @ApiResponse(responseCode="404", description="The room alias was not found.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/query/profile")
    public void queryProfile(@Parameter(name="user_id", description="The user ID to query.", required=true) @QueryParam(value="user_id") String var1, @QueryParam(value="field") String var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5);

    @Operation(summary="Exchanges an OpenID access token for information about the user who generated the token.", description="Currently this only exposes the Matrix User ID of the owner.", responses={@ApiResponse(responseCode="200", description="Information about the user who generated the OpenID access token.", content={@Content(schema=@Schema(implementation=UserInfoResponse.class))}), @ApiResponse(responseCode="401", description="The token was not recognized or has expired.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})})
    @GET
    @Path(value="/openid/userinfo")
    public void userInfo(@QueryParam(value="access_token") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Gets information on all of the user's devices.", responses={@ApiResponse(responseCode="200", description="The user's devices", content={@Content(schema=@Schema(implementation=DeviceResponse.class))})})
    @GET
    @Path(value="/user/devices/{userId}")
    public void userDevices(@Parameter(name="userId", description="The user ID to retrieve devices for. Must be a user local to the receiving homeserver.", required=true) @PathParam(value="userId") String var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Claims one-time keys for use in pre-key messages.", responses={@ApiResponse(responseCode="200", description="The claimed keys", content={@Content(schema=@Schema(implementation=KeyClaimResponse.class))})})
    @POST
    @Path(value="/user/keys/claim")
    public void userKeysClaim(@RequestBody KeyClaimRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    @Operation(summary="Returns the current devices and identity keys for the given users.", responses={@ApiResponse(responseCode="200", description="The device information", content={@Content(schema=@Schema(implementation=KeyQueryResponse.class))})})
    @POST
    @Path(value="/user/keys/query")
    public void userKeysQuery(@RequestBody KeyQueryRequest var1, @Context UriInfo var2, @Context HttpHeaders var3, @Suspended AsyncResponse var4);

    public static class QueryProfileField {
        public static final String DISPLAYNAME = "displayname";
        public static final String AVATAR_URL = "avatar_url";

        protected QueryProfileField() {
        }
    }
}

