/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.identity.model.session;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="JSON body request of the creating an email association.")
public class EmailRequestToken {
    @Schema(name="client_secret", description="A unique string generated by the client, and used to identify the validation attempt. It must be a string consisting of the characters [0-9a-zA-Z.=_-]. Its length must not exceed 255 characters and it must not be empty.", required=true)
    @JsonbProperty(value="client_secret")
    private String clientSecret;
    @Schema(description="The email address to validate.", required=true)
    private String email;
    @Schema(name="send_attempt", description="The server will only send an email if the send_attempt is a number greater than the most recent one which it has seen, scoped to that email + client_secret pair. This is to avoid repeatedly sending the same email in the case of request retries between the POSTing user and the identity server.The client should increment this value if they desire a new email(e.g.a reminder) to be sent.", required=true)
    @JsonbProperty(value="send_attempt")
    private Long sendAttempt;
    @Schema(name="next_link", description="When the validation is completed, the identity server will redirect the user to this URL.")
    @JsonbProperty(value="next_link")
    private String nextLink;

    @JsonProperty(value="client_secret")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="send_attempt")
    public Long getSendAttempt() {
        return this.sendAttempt;
    }

    public void setSendAttempt(Long sendAttempt) {
        this.sendAttempt = sendAttempt;
    }

    @JsonProperty(value="next_link")
    public String getNextLink() {
        return this.nextLink;
    }

    public void setNextLink(String nextLink) {
        this.nextLink = nextLink;
    }
}

