/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.impl.exception;

import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.RateLimitedErrorResponse;
import io.github.ma1uta.matrix.impl.exception.MatrixException;
import io.github.ma1uta.matrix.impl.exception.RateLimitedException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandler
implements ExceptionMapper<Throwable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandler.class);

    public Response toResponse(Throwable exception) {
        ErrorResponse message;
        LOGGER.error("Exception:", exception);
        Integer status = null;
        if (exception instanceof RateLimitedException) {
            RateLimitedException rateLimitedException = (RateLimitedException)exception;
            message = new RateLimitedErrorResponse(rateLimitedException.getErrcode(), rateLimitedException.getMessage(), rateLimitedException.getRetryAfterMs());
            status = rateLimitedException.getStatus();
        } else if (exception instanceof MatrixException) {
            MatrixException matrixException = (MatrixException)exception;
            message = new ErrorResponse(matrixException.getErrcode(), matrixException.getMessage());
            status = matrixException.getStatus();
        } else {
            message = this.message(exception);
        }
        return Response.status((int)(status != null ? status : 500)).entity((Object)message).build();
    }

    protected ErrorResponse message(Throwable throwable) {
        return new ErrorResponse("M_INTERNAL", throwable.getMessage());
    }
}

