/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.impl;

import io.github.ma1uta.matrix.Id;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatrixId
extends Id {
    private static final Logger LOGGER = LoggerFactory.getLogger(Id.class);
    public static final Pattern PATTERN = Pattern.compile("^[@!$#+]([^:]+):(.+)$");
    public static final Pattern USER = Pattern.compile("[a-z0-9._=\\-/]+");
    public static final Pattern DOMAIN = Pattern.compile("(\\d{3}.\\d{3}.\\d{3}.\\d{3}|\\[[0-9\\p{Alpha}:]{0,39}]|[0-9\\-.\\p{Alpha}]{1,255})(:[\\d]+)?");

    protected Matcher validate(String id) {
        if (id == null || id.trim().isEmpty()) {
            String message = "Empty id";
            LOGGER.error(message);
            throw new IllegalArgumentException(message);
        }
        Matcher matcher = PATTERN.matcher(id.trim());
        if (!matcher.matches()) {
            String message = String.format("Invalid id: '%s'", id);
            LOGGER.error(message);
            throw new IllegalArgumentException(message);
        }
        String localpart = matcher.group(1);
        String domain = matcher.group(2);
        LOGGER.trace("localpart: '%s', domain: '%s'", (Object)localpart, (Object)domain);
        Matcher domainMatcher = DOMAIN.matcher(domain);
        if (!domainMatcher.matches()) {
            String message = String.format("Invalid domain part: '%s'", domain);
            LOGGER.error(message);
            throw new IllegalArgumentException(message);
        }
        return matcher;
    }

    protected boolean userMatchers(Matcher matcher) {
        return USER.matcher(matcher.group(1)).matches();
    }

    protected boolean eventMatchers(Matcher matcher) {
        return true;
    }

    protected boolean roomMatchers(Matcher matcher) {
        return true;
    }

    protected boolean aliasMatchers(Matcher matcher) {
        return true;
    }

    protected boolean groupMatchers(Matcher matcher) {
        return true;
    }
}

