/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.EventContent;
import io.github.ma1uta.matrix.events.encrypted.MegolmEncrypted;
import io.github.ma1uta.matrix.events.encrypted.OlmEncrypted;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="This event type is used when sending encrypted events. It can be used either within a room (in which case it will have all of the Room Event fields), or as a to-device event.", subTypes={MegolmEncrypted.class, OlmEncrypted.class})
public abstract class RoomEncrypted
implements EventContent {
    @ApiModelProperty(name="sender_key", value="The Curve25519 key of the sender.", required=true)
    @JsonProperty(value="sender_key")
    private String senderKey;
    @ApiModelProperty(name="device_id", value="The ID of the sending device. Required with Megolm.")
    @JsonProperty(value="device_id")
    private String deviceId;
    @ApiModelProperty(name="session_id", value="The ID of the session used to encrypt the message. Required with Megolm.")
    @JsonProperty(value="session_id")
    private String sessionId;

    @ApiModelProperty(name="algorithm", value="The encryption algorithm used to encrypt this event. The value of this field determines which other properties will be present.", required=true, allowableValues="m.olm.v1.curve25519-aes-sha2, m.megolm.v1.aes-sha2")
    @JsonProperty(value="algorithm", access=JsonProperty.Access.READ_ONLY)
    public abstract String getAlgorithm();

    public String getSenderKey() {
        return this.senderKey;
    }

    public void setSenderKey(String senderKey) {
        this.senderKey = senderKey;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }
}

