/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.TagApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.tag.Tags;
import io.github.ma1uta.matrix.event.nested.TagInfo;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class TagMethods
extends AbstractMethods {
    public TagMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<Tags> show(String roomId) {
        String userId = this.defaults().getUserId();
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", userId).path("roomId", roomId);
        return this.factory().get(TagApi.class, "showTags", params, Tags.class);
    }

    public CompletableFuture<EmptyResponse> add(String roomId, String tag, Long order) {
        String userId = this.defaults().getUserId();
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        Objects.requireNonNull(tag, "TagInfo cannot be empty.");
        TagInfo tagInfo = new TagInfo();
        tagInfo.setOrder(order);
        RequestParams params = this.defaults().clone().path("userId", userId).path("roomId", roomId).path("tag", tag);
        return this.factory().put(TagApi.class, "addTag", params, tagInfo, EmptyResponse.class);
    }

    public CompletableFuture<EmptyResponse> delete(String roomId, String tag) {
        String userId = this.defaults().getUserId();
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        Objects.requireNonNull(tag, "TagContent cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", userId).path("roomId", roomId).path("tag", tag);
        return this.factory().delete(TagApi.class, "deleteTag", params);
    }
}

