/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.AbstractClientBuilder;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AccountMethods;
import io.github.ma1uta.matrix.client.methods.AdminMethods;
import io.github.ma1uta.matrix.client.methods.AuthMethods;
import io.github.ma1uta.matrix.client.methods.CapabilityMethods;
import io.github.ma1uta.matrix.client.methods.ClientConfigMethods;
import io.github.ma1uta.matrix.client.methods.ContentMethods;
import io.github.ma1uta.matrix.client.methods.DeviceMethods;
import io.github.ma1uta.matrix.client.methods.EncryptionMethods;
import io.github.ma1uta.matrix.client.methods.EventContextMethods;
import io.github.ma1uta.matrix.client.methods.EventMethods;
import io.github.ma1uta.matrix.client.methods.FilterMethods;
import io.github.ma1uta.matrix.client.methods.PresenceMethods;
import io.github.ma1uta.matrix.client.methods.ProfileMethods;
import io.github.ma1uta.matrix.client.methods.ProtocolMethods;
import io.github.ma1uta.matrix.client.methods.PushMethods;
import io.github.ma1uta.matrix.client.methods.ReceiptMethods;
import io.github.ma1uta.matrix.client.methods.ReportMethods;
import io.github.ma1uta.matrix.client.methods.RoomMethods;
import io.github.ma1uta.matrix.client.methods.SearchMethods;
import io.github.ma1uta.matrix.client.methods.SendToDeviceMethods;
import io.github.ma1uta.matrix.client.methods.SyncMethods;
import io.github.ma1uta.matrix.client.methods.TagMethods;
import io.github.ma1uta.matrix.client.methods.TypingMethods;
import io.github.ma1uta.matrix.client.methods.UserDirectoryMethods;
import io.github.ma1uta.matrix.client.methods.VersionMethods;
import io.github.ma1uta.matrix.client.methods.VoipMethods;
import io.github.ma1uta.matrix.client.model.auth.LoginResponse;
import java.io.Closeable;
import java.util.Objects;

public class MatrixClient
implements Closeable {
    private final RequestFactory requestFactory;
    private final RequestParams defaultParams;

    public MatrixClient(RequestFactory requestFactory) {
        this(requestFactory, new RequestParams());
    }

    public MatrixClient(RequestFactory requestFactory, RequestParams defaultParams) {
        this.defaultParams = Objects.requireNonNull(defaultParams, "The default `RequestParams` should be specified.");
        this.requestFactory = requestFactory;
    }

    public String getAccessToken() {
        return this.getDefaultParams().getAccessToken();
    }

    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public RequestParams getDefaultParams() {
        return this.defaultParams;
    }

    public String getHomeserverUrl() {
        return this.getRequestFactory().getHomeserverUrl();
    }

    @Override
    public void close() {
        this.auth().logout();
    }

    public AccountMethods account() {
        return new AccountMethods(this.getRequestFactory(), this.getDefaultParams(), this::afterLogin);
    }

    public AdminMethods admin() {
        return new AdminMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public AuthMethods auth() {
        return new AuthMethods(this.getRequestFactory(), this.getDefaultParams(), this::afterLogin, this::afterLogout);
    }

    public ClientConfigMethods clientConfig() {
        return new ClientConfigMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public ContentMethods content() {
        return new ContentMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public DeviceMethods device() {
        return new DeviceMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public EncryptionMethods encryption() {
        return new EncryptionMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public EventContextMethods eventContext() {
        return new EventContextMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public PresenceMethods presence() {
        return new PresenceMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public ProfileMethods profile() {
        return new ProfileMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public ReceiptMethods receipt() {
        return new ReceiptMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public ReportMethods report() {
        return new ReportMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public SearchMethods search() {
        return new SearchMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public SendToDeviceMethods sendToDevice() {
        return new SendToDeviceMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public SyncMethods sync() {
        return new SyncMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public EventMethods event() {
        return new EventMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public FilterMethods filter() {
        return new FilterMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public RoomMethods room() {
        return new RoomMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public TagMethods tag() {
        return new TagMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public TypingMethods typing() {
        return new TypingMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public UserDirectoryMethods userDirectory() {
        return new UserDirectoryMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public VersionMethods versions() {
        return new VersionMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public VoipMethods turnServers() {
        return new VoipMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public PushMethods push() {
        return new PushMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public ProtocolMethods protocol() {
        return new ProtocolMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public CapabilityMethods capabilities() {
        return new CapabilityMethods(this.getRequestFactory(), this.getDefaultParams());
    }

    public String getUserId() {
        return this.getDefaultParams().getUserId();
    }

    public LoginResponse afterLogin(LoginResponse loginResponse) {
        if (loginResponse == null) {
            this.getDefaultParams().accessToken(null);
        } else {
            this.getDefaultParams().userId(loginResponse.getUserId());
            this.getDefaultParams().accessToken(loginResponse.getAccessToken());
            this.getDefaultParams().deviceId(loginResponse.getDeviceId());
        }
        return loginResponse;
    }

    public EmptyResponse afterLogout(EmptyResponse response) {
        this.getDefaultParams().accessToken(null);
        this.getDefaultParams().deviceId(null);
        return response;
    }

    public static class Builder
    extends AbstractClientBuilder<MatrixClient> {
        @Override
        public MatrixClient newInstance() {
            return new MatrixClient(this.getFactory(), this.getDefaultParams());
        }
    }
}

