/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.Id;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.api.TagApi;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.methods.AbstractMethods;
import io.github.ma1uta.matrix.client.model.tag.Tags;
import io.github.ma1uta.matrix.event.nested.TagInfo;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class TagMethods
extends AbstractMethods {
    public TagMethods(RequestFactory factory, RequestParams defaultParams) {
        super(factory, defaultParams);
    }

    public CompletableFuture<Tags> show(Id roomId) {
        Id userId = this.defaults().getUserId();
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", userId.toString()).path("roomId", roomId.toString());
        return this.factory().get(TagApi.class, "showTags", params, Tags.class);
    }

    public CompletableFuture<EmptyResponse> add(Id roomId, String tag, Long order) {
        Id userId = this.defaults().getUserId();
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        Objects.requireNonNull(tag, "TagInfo cannot be empty.");
        TagInfo tagInfo = new TagInfo();
        tagInfo.setOrder(order);
        RequestParams params = this.defaults().clone().path("userId", userId.toString()).path("roomId", roomId.toString()).path("tag", tag);
        return this.factory().put(TagApi.class, "addTag", params, tagInfo, EmptyResponse.class);
    }

    public CompletableFuture<EmptyResponse> delete(Id roomId, String tag) {
        Id userId = this.defaults().getUserId();
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        Objects.requireNonNull(tag, "TagContent cannot be empty.");
        RequestParams params = this.defaults().clone().path("userId", userId.toString()).path("roomId", roomId.toString()).path("tag", tag);
        return this.factory().delete(TagApi.class, "deleteTag", params);
    }
}

