/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.blocked;

import io.github.ma1uta.matrix.client.rest.blocked.ThirdPartyProtocolApi;
import io.github.ma1uta.matrix.protocol.Protocol;
import io.github.ma1uta.matrix.protocol.ProtocolLocation;
import io.github.ma1uta.matrix.protocol.ProtocolUser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class ProtocolMethods {
    private final ThirdPartyProtocolApi thirdPartyProtocolApi;

    public ProtocolMethods(RestClientBuilder restClientBuilder) {
        this.thirdPartyProtocolApi = (ThirdPartyProtocolApi)restClientBuilder.build(ThirdPartyProtocolApi.class);
    }

    public Map<String, Protocol> protocols() {
        return this.thirdPartyProtocolApi.protocols();
    }

    public Protocol protocol(String protocol) {
        Objects.requireNonNull(protocol, "Protocol cannot be empty.");
        return this.thirdPartyProtocolApi.protocol(protocol);
    }

    public List<ProtocolLocation> locations(String protocol) {
        Objects.requireNonNull(protocol, "Protocol cannot be empty.");
        return this.thirdPartyProtocolApi.location(protocol);
    }

    public List<ProtocolUser> users(String protocol) {
        Objects.requireNonNull(protocol, "Protocol cannot be empty.");
        return this.thirdPartyProtocolApi.userProtocol(protocol);
    }

    public List<ProtocolLocation> location(String alias) {
        Objects.requireNonNull(alias, "Alias cannot be empty.");
        return this.thirdPartyProtocolApi.location(alias);
    }

    public List<ProtocolUser> user(String userId) {
        Objects.requireNonNull(userId, "userId cannot be empty.");
        return this.thirdPartyProtocolApi.user(userId);
    }
}

