/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.blocked;

import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.model.account.AuthenticationData;
import io.github.ma1uta.matrix.client.model.device.Device;
import io.github.ma1uta.matrix.client.model.device.DeviceUpdateRequest;
import io.github.ma1uta.matrix.client.model.device.DevicesDeleteRequest;
import io.github.ma1uta.matrix.client.model.device.DevicesResponse;
import io.github.ma1uta.matrix.client.rest.blocked.DeviceApi;
import io.github.ma1uta.matrix.common.EmptyResponse;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class DeviceMethods {
    private final DeviceApi deviceApi;
    private final ConnectionInfo connectionInfo;

    public DeviceMethods(RestClientBuilder restClientBuilder, ConnectionInfo connectionInfo) {
        this.deviceApi = (DeviceApi)restClientBuilder.build(DeviceApi.class);
        this.connectionInfo = connectionInfo;
    }

    public DevicesResponse devices() {
        return this.deviceApi.devices();
    }

    public Device device(String deviceId) {
        Objects.requireNonNull(deviceId, "DeviceId cannot be empty.");
        return this.deviceApi.device(deviceId);
    }

    public EmptyResponse update(String deviceId, String displayName) {
        Objects.requireNonNull(deviceId, "DeviceId cannot be empty.");
        DeviceUpdateRequest request = new DeviceUpdateRequest();
        request.setDisplayName(displayName);
        return this.deviceApi.updateDevice(deviceId, request);
    }

    public EmptyResponse delete(AuthenticationData auth) {
        DevicesDeleteRequest request = new DevicesDeleteRequest();
        request.setAuth(auth);
        List<String> devices = Collections.singletonList(this.connectionInfo.getDeviceId());
        request.setDevices(devices);
        EmptyResponse response = this.deviceApi.deleteDevices(request);
        this.connectionInfo.setDeviceId(null);
        this.connectionInfo.setAccessToken(null);
        return response;
    }

    public EmptyResponse deleteDevices(DevicesDeleteRequest request) {
        String error = "Devices cannot be empty.";
        Objects.requireNonNull(request.getDevices(), error);
        if (request.getDevices().isEmpty()) {
            throw new NullPointerException(error);
        }
        EmptyResponse response = this.deviceApi.deleteDevices(request);
        if (request.getDevices().contains(this.connectionInfo.getDeviceId())) {
            this.connectionInfo.setDeviceId(null);
            this.connectionInfo.setAccessToken(null);
        }
        return response;
    }
}

