/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.blocked;

import io.github.ma1uta.matrix.client.ContentUriModel;
import io.github.ma1uta.matrix.client.model.content.ContentConfig;
import io.github.ma1uta.matrix.client.model.content.ContentUri;
import io.github.ma1uta.matrix.client.rest.blocked.ContentApi;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class ContentMethods {
    private final ContentApi contentApi;
    private static final Pattern CONTENT_DISPOSITION = Pattern.compile("filename=\"?(.*)\"?");

    public ContentMethods(RestClientBuilder restClientBuilder) {
        this.contentApi = (ContentApi)restClientBuilder.build(ContentApi.class);
    }

    public ContentUri upload(InputStream inputStream, String filename, String contentType) {
        return this.contentApi.upload(inputStream, filename, contentType);
    }

    public Content download(String contentUri, Boolean allowRemote) {
        Objects.requireNonNull(contentUri, "ContentUri cannot be empty.");
        ContentUriModel uriModel = ContentUriModel.valueOf(contentUri);
        return this.download(uriModel.getServer(), uriModel.getMediaId(), allowRemote);
    }

    public Content download(String serverName, String mediaId, Boolean allowRemote) {
        Objects.requireNonNull(serverName, "ServerName cannot be empty.");
        Objects.requireNonNull(mediaId, "MediaId cannot be empty.");
        return ContentMethods.toContent(this.contentApi.download(serverName, mediaId, allowRemote));
    }

    public Content downloadFile(String contentUri, String filename, Boolean allowRemote) {
        Objects.requireNonNull(contentUri, "ContentUri cannot be empty.");
        ContentUriModel uriModel = ContentUriModel.valueOf(contentUri);
        return this.downloadFile(uriModel.getServer(), uriModel.getMediaId(), filename, allowRemote);
    }

    public Content downloadFile(String serverName, String mediaId, String filename, Boolean allowRemote) {
        Objects.requireNonNull(serverName, "ServerName cannot be empty.");
        Objects.requireNonNull(mediaId, "MediaId cannot be empty.");
        return ContentMethods.toContent(this.contentApi.downloadFile(serverName, mediaId, filename, allowRemote));
    }

    public Thumbnail thumbnail(String contentUri, Long width, Long height, String method, Boolean allowRemote) {
        Objects.requireNonNull(contentUri, "ContentUri cannot be empty.");
        ContentUriModel uriModel = ContentUriModel.valueOf(contentUri);
        return ContentMethods.toThumbnail(this.contentApi.thumbnail(uriModel.getServer(), uriModel.getMediaId(), width, height, method, allowRemote));
    }

    public Thumbnail thumbnail(String serverName, String mediaId, Long width, Long height, String method, Boolean allowRemote) {
        Objects.requireNonNull(serverName, "ServerName cannot be empty.");
        Objects.requireNonNull(mediaId, "MediaId cannot be empty.");
        return ContentMethods.toThumbnail(this.contentApi.thumbnail(serverName, mediaId, width, height, method, allowRemote));
    }

    public Map<String, String> previewInfo(String url, String ts) {
        Objects.requireNonNull(url, "Url cannot be empty.");
        return this.contentApi.previewUrl(url, ts);
    }

    public ContentConfig getUploadSize() {
        return this.contentApi.config();
    }

    public static Content toContent(Response response) {
        String contentDisposition = response.getHeaderString("Content-Disposition");
        Matcher matcher = CONTENT_DISPOSITION.matcher(contentDisposition);
        String filename = matcher.find() ? matcher.group(1) : contentDisposition;
        String contentType = response.getHeaderString("Content-Type");
        return new Content((InputStream)response.readEntity(InputStream.class), filename, contentType);
    }

    public static Thumbnail toThumbnail(Response response) {
        String contentType = response.getHeaderString("Content-Type");
        return new Thumbnail((InputStream)response.readEntity(InputStream.class), contentType);
    }

    public static class Thumbnail {
        private final InputStream inputStream;
        private final String contentType;

        public Thumbnail(InputStream inputStream, String contentType) {
            this.inputStream = inputStream;
            this.contentType = contentType;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public String getContentType() {
            return this.contentType;
        }
    }

    public static class Content {
        private final InputStream inputStream;
        private final String filename;
        private final String contentType;

        public Content(InputStream inputStream, String filename, String contentType) {
            this.inputStream = inputStream;
            this.filename = filename;
            this.contentType = contentType;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

