/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.blocked;

import io.github.ma1uta.matrix.client.model.auth.Identifier;
import io.github.ma1uta.matrix.client.model.auth.LoginRequest;
import io.github.ma1uta.matrix.client.model.auth.LoginResponse;
import io.github.ma1uta.matrix.client.model.auth.SupportedLoginResponse;
import io.github.ma1uta.matrix.client.model.auth.UserIdentifier;
import io.github.ma1uta.matrix.client.rest.blocked.AuthApi;
import io.github.ma1uta.matrix.common.EmptyResponse;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthMethods {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthMethods.class);
    private final Function<LoginResponse, LoginResponse> afterLogin;
    private final Function<EmptyResponse, EmptyResponse> afterLogout;
    private final AuthApi authApi;

    public AuthMethods(RestClientBuilder restClientBuilder, Function<LoginResponse, LoginResponse> afterLogin, Function<EmptyResponse, EmptyResponse> afterLogout) {
        this.authApi = (AuthApi)restClientBuilder.build(AuthApi.class);
        this.afterLogin = afterLogin;
        this.afterLogout = afterLogout;
    }

    public LoginResponse login(String login, char[] password) {
        LOGGER.debug("Login with username: ''{}'' and password: ''<redacted>''", (Object)login);
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setType("m.login.password");
        UserIdentifier identifier = new UserIdentifier();
        identifier.setUser(login);
        loginRequest.setIdentifier((Identifier)identifier);
        loginRequest.setPassword(password);
        return this.login(loginRequest);
    }

    public LoginResponse login(LoginRequest loginRequest) {
        Objects.requireNonNull(loginRequest.getType(), "Type cannot be empty.");
        LoginResponse response = this.authApi.login(loginRequest);
        return this.afterLogin != null ? this.afterLogin.apply(response) : response;
    }

    public EmptyResponse logout() {
        EmptyResponse response = this.authApi.logout();
        return this.afterLogout != null ? this.afterLogout.apply(response) : response;
    }

    public EmptyResponse logoutAll() {
        EmptyResponse response = this.authApi.logoutAll();
        return this.afterLogout != null ? this.afterLogout.apply(response) : response;
    }

    public SupportedLoginResponse loginTypes() {
        return this.authApi.supportedLoginTypes();
    }
}

