/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client;

import io.github.ma1uta.matrix.client.ClientHomeServerResolver;
import io.github.ma1uta.matrix.client.ConnectionInfo;
import io.github.ma1uta.matrix.client.ResolvedHomeserver;
import io.github.ma1uta.matrix.client.filter.AuthorizationFilter;
import io.github.ma1uta.matrix.client.filter.ContentTypeFilter;
import io.github.ma1uta.matrix.client.filter.ErrorFilter;
import io.github.ma1uta.matrix.client.filter.LoggingFilter;
import io.github.ma1uta.matrix.client.methods.async.AccountAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.AdminAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.CapabilityAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.ClientConfigAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.ContentAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.DeviceAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.EncryptionAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.EventAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.EventContextAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.FilterAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.OpenIdAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.PresenceAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.ProfileAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.ProtocolAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.PushAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.ReceiptAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.ReportAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.RoomAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.SearchAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.SendToDeviceAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.SyncAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.TagAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.TypingAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.UserDirectoryAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.VersionAsyncMethods;
import io.github.ma1uta.matrix.client.methods.async.VoipAsyncMethods;
import io.github.ma1uta.matrix.client.methods.blocked.AccountMethods;
import io.github.ma1uta.matrix.client.methods.blocked.AdminMethods;
import io.github.ma1uta.matrix.client.methods.blocked.CapabilityMethods;
import io.github.ma1uta.matrix.client.methods.blocked.ClientConfigMethods;
import io.github.ma1uta.matrix.client.methods.blocked.ContentMethods;
import io.github.ma1uta.matrix.client.methods.blocked.DeviceMethods;
import io.github.ma1uta.matrix.client.methods.blocked.EncryptionMethods;
import io.github.ma1uta.matrix.client.methods.blocked.EventContextMethods;
import io.github.ma1uta.matrix.client.methods.blocked.EventMethods;
import io.github.ma1uta.matrix.client.methods.blocked.FilterMethods;
import io.github.ma1uta.matrix.client.methods.blocked.OpenIdMethods;
import io.github.ma1uta.matrix.client.methods.blocked.PresenceMethods;
import io.github.ma1uta.matrix.client.methods.blocked.ProfileMethods;
import io.github.ma1uta.matrix.client.methods.blocked.ProtocolMethods;
import io.github.ma1uta.matrix.client.methods.blocked.PushMethods;
import io.github.ma1uta.matrix.client.methods.blocked.ReceiptMethods;
import io.github.ma1uta.matrix.client.methods.blocked.ReportMethods;
import io.github.ma1uta.matrix.client.methods.blocked.RoomMethods;
import io.github.ma1uta.matrix.client.methods.blocked.SearchMethods;
import io.github.ma1uta.matrix.client.methods.blocked.SendToDeviceMethods;
import io.github.ma1uta.matrix.client.methods.blocked.SyncMethods;
import io.github.ma1uta.matrix.client.methods.blocked.TagMethods;
import io.github.ma1uta.matrix.client.methods.blocked.TypingMethods;
import io.github.ma1uta.matrix.client.methods.blocked.UserDirectoryMethods;
import io.github.ma1uta.matrix.client.methods.blocked.VersionMethods;
import io.github.ma1uta.matrix.client.methods.blocked.VoipMethods;
import io.github.ma1uta.matrix.impl.RestClientBuilderConfigurer;
import java.io.Closeable;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public abstract class MatrixClient
implements Closeable {
    private volatile URL homeserverURL = null;
    private volatile HostnameVerifier hostnameVerifier = null;
    private final ClientHomeServerResolver homeServerResolver = new ClientHomeServerResolver();
    private final Map<Class<?>, Object> methods = new ConcurrentHashMap();
    private final AuthorizationFilter authorizationFilter;
    private final ConnectionInfo connectionInfo;
    private final ExecutorService executorService;

    public MatrixClient(String domain) {
        this(new ConnectionInfo(domain));
    }

    public MatrixClient(ConnectionInfo connectionInfo) {
        this(connectionInfo, null);
    }

    public MatrixClient(ConnectionInfo connectionInfo, ExecutorService executorService) {
        this.connectionInfo = connectionInfo;
        this.authorizationFilter = new AuthorizationFilter(this.connectionInfo);
        this.executorService = executorService;
    }

    public URL getHomeserverUrl() {
        this.resolveHomeserver();
        return this.homeserverURL;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    protected synchronized void resolveHomeserver() {
        if (this.homeserverURL == null) {
            Optional<ResolvedHomeserver> optionalResolvedHomeserver = this.homeServerResolver.resolve(this.connectionInfo.getDomain());
            if (optionalResolvedHomeserver.isPresent()) {
                ResolvedHomeserver homeserver = optionalResolvedHomeserver.get();
                this.homeserverURL = homeserver.getUrl();
                this.hostnameVerifier = homeserver.getOptionalHostnameVerifier().orElse(null);
            } else {
                throw new IllegalStateException("Unable to resolve homeserver url: " + this.connectionInfo.getDomain());
            }
        }
    }

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    protected RestClientBuilder newClientBuilder() {
        this.resolveHomeserver();
        RestClientBuilder builder = ((RestClientBuilder)((RestClientBuilder)((RestClientBuilder)((RestClientBuilder)RestClientBuilder.newBuilder().register((Object)new ErrorFilter())).register((Object)new LoggingFilter())).register((Object)this.authorizationFilter)).register((Object)new ContentTypeFilter())).baseUrl(this.getHomeserverUrl());
        if (this.hostnameVerifier != null) {
            builder.hostnameVerifier(this.hostnameVerifier);
        }
        if (this.getExecutorService() != null) {
            builder.executorService(this.executorService);
        }
        return builder;
    }

    protected RestClientBuilder getClientBuilder() {
        RestClientBuilder builder = this.newClientBuilder();
        ServiceLoader.load(RestClientBuilderConfigurer.class).iterator().forEachRemaining(c -> c.configure(builder));
        return builder;
    }

    protected <T> T getMethod(Class<T> clazz, Supplier<T> creator) {
        return clazz.cast(this.methods.computeIfAbsent(clazz, key -> creator.get()));
    }

    public String getDomain() {
        return this.getConnectionInfo().getDomain();
    }

    public String getAccessToken() {
        return this.getConnectionInfo().getAccessToken();
    }

    @Override
    public void close() {
    }

    public abstract AccountAsyncMethods accountAsync();

    public abstract AccountMethods account();

    public AdminAsyncMethods adminAsync() {
        return this.getMethod(AdminAsyncMethods.class, () -> new AdminAsyncMethods(this.getClientBuilder()));
    }

    public AdminMethods admin() {
        return this.getMethod(AdminMethods.class, () -> new AdminMethods(this.getClientBuilder()));
    }

    public ClientConfigAsyncMethods clientConfigAsync() {
        return this.getMethod(ClientConfigAsyncMethods.class, () -> new ClientConfigAsyncMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public ClientConfigMethods clientConfig() {
        return this.getMethod(ClientConfigMethods.class, () -> new ClientConfigMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public ContentAsyncMethods contentAsync() {
        return this.getMethod(ContentAsyncMethods.class, () -> new ContentAsyncMethods(this.getClientBuilder()));
    }

    public ContentMethods content() {
        return this.getMethod(ContentMethods.class, () -> new ContentMethods(this.getClientBuilder()));
    }

    public DeviceAsyncMethods deviceAsync() {
        return this.getMethod(DeviceAsyncMethods.class, () -> new DeviceAsyncMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public DeviceMethods device() {
        return this.getMethod(DeviceMethods.class, () -> new DeviceMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public EncryptionAsyncMethods encryptionAsync() {
        return this.getMethod(EncryptionAsyncMethods.class, () -> new EncryptionAsyncMethods(this.getClientBuilder()));
    }

    public EncryptionMethods encryption() {
        return this.getMethod(EncryptionMethods.class, () -> new EncryptionMethods(this.getClientBuilder()));
    }

    public EventContextAsyncMethods eventContextAsync() {
        return this.getMethod(EventContextAsyncMethods.class, () -> new EventContextAsyncMethods(this.getClientBuilder()));
    }

    public EventContextMethods eventContext() {
        return this.getMethod(EventContextMethods.class, () -> new EventContextMethods(this.getClientBuilder()));
    }

    public PresenceAsyncMethods presenceAsync() {
        return this.getMethod(PresenceAsyncMethods.class, () -> new PresenceAsyncMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public PresenceMethods presence() {
        return this.getMethod(PresenceMethods.class, () -> new PresenceMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public ProfileAsyncMethods profileAsync() {
        return this.getMethod(ProfileAsyncMethods.class, () -> new ProfileAsyncMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public ProfileMethods profile() {
        return this.getMethod(ProfileMethods.class, () -> new ProfileMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public ReceiptAsyncMethods receiptAsync() {
        return this.getMethod(ReceiptAsyncMethods.class, () -> new ReceiptAsyncMethods(this.getClientBuilder()));
    }

    public ReceiptMethods receipt() {
        return this.getMethod(ReceiptMethods.class, () -> new ReceiptMethods(this.getClientBuilder()));
    }

    public ReportAsyncMethods reportAsync() {
        return this.getMethod(ReportAsyncMethods.class, () -> new ReportAsyncMethods(this.getClientBuilder()));
    }

    public ReportMethods report() {
        return this.getMethod(ReportMethods.class, () -> new ReportMethods(this.getClientBuilder()));
    }

    public SearchAsyncMethods searchAsync() {
        return this.getMethod(SearchAsyncMethods.class, () -> new SearchAsyncMethods(this.getClientBuilder()));
    }

    public SearchMethods search() {
        return this.getMethod(SearchMethods.class, () -> new SearchMethods(this.getClientBuilder()));
    }

    public SendToDeviceAsyncMethods sendToDeviceAsync() {
        return this.getMethod(SendToDeviceAsyncMethods.class, () -> new SendToDeviceAsyncMethods(this.getClientBuilder()));
    }

    public SendToDeviceMethods sendToDevice() {
        return this.getMethod(SendToDeviceMethods.class, () -> new SendToDeviceMethods(this.getClientBuilder()));
    }

    public SyncAsyncMethods syncAsync() {
        return this.getMethod(SyncAsyncMethods.class, () -> new SyncAsyncMethods(this.getClientBuilder()));
    }

    public SyncMethods sync() {
        return this.getMethod(SyncMethods.class, () -> new SyncMethods(this.getClientBuilder()));
    }

    public EventAsyncMethods eventAsync() {
        return this.getMethod(EventAsyncMethods.class, () -> new EventAsyncMethods(this.getClientBuilder()));
    }

    public EventMethods event() {
        return this.getMethod(EventMethods.class, () -> new EventMethods(this.getClientBuilder()));
    }

    public FilterAsyncMethods filterAsync() {
        return this.getMethod(FilterAsyncMethods.class, () -> new FilterAsyncMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public FilterMethods filter() {
        return this.getMethod(FilterMethods.class, () -> new FilterMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public RoomAsyncMethods roomAsync() {
        return this.getMethod(RoomAsyncMethods.class, () -> new RoomAsyncMethods(this.getClientBuilder()));
    }

    public RoomMethods room() {
        return this.getMethod(RoomMethods.class, () -> new RoomMethods(this.getClientBuilder()));
    }

    public TagAsyncMethods tagAsync() {
        return this.getMethod(TagAsyncMethods.class, () -> new TagAsyncMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public TagMethods tag() {
        return this.getMethod(TagMethods.class, () -> new TagMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public TypingAsyncMethods typingAsync() {
        return this.getMethod(TypingAsyncMethods.class, () -> new TypingAsyncMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public TypingMethods typing() {
        return this.getMethod(TypingMethods.class, () -> new TypingMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public UserDirectoryAsyncMethods userDirectoryAsync() {
        return this.getMethod(UserDirectoryAsyncMethods.class, () -> new UserDirectoryAsyncMethods(this.getClientBuilder()));
    }

    public UserDirectoryMethods userDirectory() {
        return this.getMethod(UserDirectoryMethods.class, () -> new UserDirectoryMethods(this.getClientBuilder()));
    }

    public VersionAsyncMethods versionsAsync() {
        return this.getMethod(VersionAsyncMethods.class, () -> new VersionAsyncMethods(this.getClientBuilder()));
    }

    public VersionMethods versions() {
        return this.getMethod(VersionMethods.class, () -> new VersionMethods(this.getClientBuilder()));
    }

    public VoipAsyncMethods turnServersAsync() {
        return this.getMethod(VoipAsyncMethods.class, () -> new VoipAsyncMethods(this.getClientBuilder()));
    }

    public VoipMethods turnServers() {
        return this.getMethod(VoipMethods.class, () -> new VoipMethods(this.getClientBuilder()));
    }

    public PushAsyncMethods pushAsync() {
        return this.getMethod(PushAsyncMethods.class, () -> new PushAsyncMethods(this.getClientBuilder()));
    }

    public PushMethods push() {
        return this.getMethod(PushMethods.class, () -> new PushMethods(this.getClientBuilder()));
    }

    public ProtocolAsyncMethods protocolAsync() {
        return this.getMethod(ProtocolAsyncMethods.class, () -> new ProtocolAsyncMethods(this.getClientBuilder()));
    }

    public ProtocolMethods protocol() {
        return this.getMethod(ProtocolMethods.class, () -> new ProtocolMethods(this.getClientBuilder()));
    }

    public CapabilityAsyncMethods capabilitiesAsync() {
        return this.getMethod(CapabilityAsyncMethods.class, () -> new CapabilityAsyncMethods(this.getClientBuilder()));
    }

    public CapabilityMethods capabilities() {
        return this.getMethod(CapabilityMethods.class, () -> new CapabilityMethods(this.getClientBuilder()));
    }

    public OpenIdAsyncMethods openIdAsync() {
        return this.getMethod(OpenIdAsyncMethods.class, () -> new OpenIdAsyncMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public OpenIdMethods openId() {
        return this.getMethod(OpenIdMethods.class, () -> new OpenIdMethods(this.getClientBuilder(), this.getConnectionInfo()));
    }

    public String getUserId() {
        return this.getConnectionInfo().getUserId();
    }
}

