/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client;

import io.github.ma1uta.matrix.client.HomeServerVerifier;
import io.github.ma1uta.matrix.client.ResolvedHomeserver;
import io.github.ma1uta.matrix.client.filter.StreamHelper;
import io.github.ma1uta.matrix.client.model.serverdiscovery.HomeserverInfo;
import io.github.ma1uta.matrix.client.model.serverdiscovery.ServerDiscoveryResponse;
import io.github.ma1uta.matrix.client.model.version.VersionsResponse;
import io.github.ma1uta.matrix.impl.Deserializer;
import io.github.ma1uta.matrix.impl.exception.MatrixException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHomeServerResolver {
    private static final int SRV_RECORD_PARAMETER_COUNT = 4;
    private static final int SRV_RECORD_POST_INDEX = 2;
    private static final int SRV_RECORD_HOST_INDEX = 3;
    private static final String SCHEMA_PREFIX = "https://";
    private static final int DEFAULT_PORT = 8448;
    public static final String DISABLE_HOMESERVER_URL_VERIFICATION = "jmsdk.resolver.homeserver.verification.disable";
    private static final Pattern IPv4_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])(:\\d{2,5})?$");
    private static final Pattern IPv6_PATTERN = Pattern.compile("^([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}$|^\\[([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}]:\\d{2,5}$");
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHomeServerResolver.class);
    private final Deserializer deserializer = ServiceLoader.load(Deserializer.class).iterator().next();
    private final Boolean homeserverVerificationDisabled;

    public AbstractHomeServerResolver() {
        this(null);
    }

    public AbstractHomeServerResolver(Boolean homeserverVerificationDisabled) {
        this.homeserverVerificationDisabled = homeserverVerificationDisabled;
    }

    protected boolean isHomeserverVerificationDisabled() {
        return this.homeserverVerificationDisabled != null && this.homeserverVerificationDisabled != false || Objects.equals(System.getProperty(DISABLE_HOMESERVER_URL_VERIFICATION), Boolean.TRUE.toString());
    }

    public Optional<ResolvedHomeserver> resolve(String domain) {
        LOGGER.trace("Resolve: {}", (Object)domain);
        return this.validateResolvedHomeserver(domain, this.resolveDomain(domain));
    }

    protected abstract Optional<ResolvedHomeserver> resolveDomain(String var1);

    protected boolean isValidHomeserverUrl(ResolvedHomeserver homeserver) {
        String version = homeserver.getUrl().toString() + "/_matrix/client/versions";
        try {
            VersionsResponse response;
            URLConnection connection = new URL(version).openConnection();
            if (connection instanceof HttpsURLConnection && homeserver.getOptionalHostnameVerifier().isPresent()) {
                ((HttpsURLConnection)connection).setHostnameVerifier(homeserver.getOptionalHostnameVerifier().get());
            }
            try (InputStream inputStream = connection.getInputStream();){
                byte[] content = StreamHelper.toByteArray(inputStream);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Content from {}: {}", (Object)version, (Object)new String(content, StandardCharsets.UTF_8));
                }
                response = (VersionsResponse)this.deserializer.deserialize(content, VersionsResponse.class);
            }
            if (LOGGER.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder("Server: ").append(homeserver.getUrl()).append("\nVersions:\n");
                for (String string : response.getVersions()) {
                    sb.append("- ").append(string).append("\n");
                }
                if (response.getUnstableFeatures() != null) {
                    sb.append("Features:\n");
                    for (Map.Entry entry : response.getUnstableFeatures().entrySet()) {
                        sb.append("- ").append((String)entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                    }
                }
                LOGGER.trace(sb.toString());
            }
        }
        catch (IOException e) {
            LOGGER.error("Wrong url: " + version, (Throwable)e);
            return false;
        }
        return true;
    }

    protected Optional<ResolvedHomeserver> tryParseIPAddresses(String domain) {
        LOGGER.trace("Try resolve as ip addresses");
        Matcher matcher = IPv4_PATTERN.matcher(domain);
        if (matcher.matches()) {
            try {
                return Optional.of(new ResolvedHomeserver(new URL(domain)));
            }
            catch (MalformedURLException e) {
                LOGGER.error("Unable to parse IPv4 address: " + domain, (Throwable)e);
            }
        }
        if ((matcher = IPv6_PATTERN.matcher(domain)).matches()) {
            try {
                return Optional.of(new ResolvedHomeserver(new URL(domain)));
            }
            catch (MalformedURLException e) {
                LOGGER.error("Unable to parse IPv6 address: " + domain, (Throwable)e);
            }
        }
        LOGGER.trace("Unable to resolve as IPv4 or IPv6 addresses: {}, try other way.", (Object)domain);
        return Optional.empty();
    }

    protected Optional<ResolvedHomeserver> tryDirectUrl(String domain) {
        LOGGER.trace("Try resolve via direct url.");
        int portIndex = domain.lastIndexOf(":");
        String domainWithPort = portIndex != -1 ? domain : domain + ":" + 8448;
        int schemaIndex = domain.indexOf("://");
        String homeserverUrl = schemaIndex != -1 ? domainWithPort : SCHEMA_PREFIX + domainWithPort;
        try {
            return Optional.of(new ResolvedHomeserver(new URL(homeserverUrl)));
        }
        catch (MalformedURLException e) {
            LOGGER.warn("Malformed homeserver url: " + homeserverUrl, (Throwable)e);
            return Optional.empty();
        }
    }

    protected Optional<ResolvedHomeserver> trySrvRecord(String domain) {
        LOGGER.trace("Try resolve via SRV record.");
        String srvRecord = String.format("_matrix._tcp.%s", domain);
        try {
            InitialDirContext dirContext = this.prepareContext();
            if (dirContext == null) {
                LOGGER.warn("Unable to initialize DNS context");
                return Optional.empty();
            }
            Attributes attributes = dirContext.getAttributes(srvRecord, new String[]{"SRV"});
            NamingEnumeration<?> srv = attributes.get("srv").getAll();
            if (srv.hasMore()) {
                Object nextValue = srv.next();
                if (nextValue instanceof String) {
                    URL homeserverUrl = this.parseSrvRecord((String)nextValue);
                    if (homeserverUrl != null) {
                        return Optional.of(new ResolvedHomeserver(homeserverUrl, new HomeServerVerifier(domain)));
                    }
                } else {
                    LOGGER.warn("Unrecognized SRV record: {}", nextValue.getClass());
                }
            }
        }
        catch (NamingException e) {
            LOGGER.warn("Unable to fetch SRV record: " + srvRecord, (Throwable)e);
        }
        LOGGER.trace("Unable to resolve via SRV record: {}, try other way.", (Object)domain);
        return Optional.empty();
    }

    protected InitialDirContext prepareContext() {
        InitialDirContext context;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns:");
        try {
            context = new InitialDirContext(env);
        }
        catch (NamingException e) {
            LOGGER.error("Unable to create naming context", (Throwable)e);
            return null;
        }
        return context;
    }

    protected URL parseSrvRecord(String record) {
        LOGGER.trace("SRV record: {}", (Object)record);
        String[] params = record.split(" ");
        if (params.length == 4) {
            String homeserverUrl = SCHEMA_PREFIX + params[3];
            if (homeserverUrl.endsWith(".")) {
                homeserverUrl = homeserverUrl.substring(0, homeserverUrl.length() - 1);
            }
            homeserverUrl = homeserverUrl + ":" + params[2];
            try {
                return new URL(homeserverUrl);
            }
            catch (MalformedURLException e) {
                LOGGER.error("Malformed homeserver url: " + homeserverUrl);
            }
        }
        LOGGER.info("Unable to parse SRV record: {}, try other way.", (Object)record);
        return null;
    }

    protected Optional<ResolvedHomeserver> tryWellKnown(String domain) {
        LOGGER.trace("Try resolve via well-known");
        String homeserverUrl = SCHEMA_PREFIX + domain;
        ServerDiscoveryResponse response = null;
        try {
            String wellKnownUrl = homeserverUrl + "/.well-known/matrix/client";
            try (InputStream inputStream = new URL(wellKnownUrl).openStream();){
                byte[] content = StreamHelper.toByteArray(inputStream);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Content from {}: {}", (Object)wellKnownUrl, (Object)new String(content, StandardCharsets.UTF_8));
                }
                response = (ServerDiscoveryResponse)this.deserializer.deserialize(content, ServerDiscoveryResponse.class);
            }
        }
        catch (MatrixException e) {
            LOGGER.trace("Unable to connect to homeserver " + homeserverUrl, (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.trace("Unable to discover homeserver url: " + homeserverUrl, (Throwable)e);
        }
        if (response == null) {
            LOGGER.trace("Unable to get homeserver url of the domain '{}' via well-known, try other steps.", (Object)domain);
            return Optional.empty();
        }
        HomeserverInfo homeserver = response.getHomeserver();
        if (homeserver != null && homeserver.getBaseUrl() != null && !homeserver.getBaseUrl().trim().isEmpty()) {
            String baseUrl = homeserver.getBaseUrl();
            if (baseUrl.endsWith("/")) {
                baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
            }
            try {
                return Optional.of(new ResolvedHomeserver(new URL(baseUrl)));
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Malformed homeserver url: " + baseUrl, (Throwable)e);
            }
        }
        LOGGER.trace("Unable to get homeserver url of the domain '{}' via well-known, try other way.", (Object)domain);
        return Optional.empty();
    }

    protected Optional<ResolvedHomeserver> validateResolvedHomeserver(String domain, Optional<ResolvedHomeserver> resolvedHomeserver) {
        if (!resolvedHomeserver.isPresent()) {
            LOGGER.error("Unable to resolve homeserver url of the domain: {}", (Object)domain);
            return Optional.empty();
        }
        ResolvedHomeserver homeserver = resolvedHomeserver.get();
        if (this.isHomeserverVerificationDisabled()) {
            LOGGER.trace("Checking homeserver url disabled.");
        } else {
            LOGGER.trace("Check homeserver url: {}", (Object)homeserver);
            boolean valid = this.isValidHomeserverUrl(homeserver);
            if (!valid) {
                LOGGER.error("Unable to check the homeserver url: {}", (Object)homeserver);
                return Optional.empty();
            }
        }
        LOGGER.info("Resolved: {} => {}", (Object)domain, (Object)homeserver.toString());
        return resolvedHomeserver;
    }
}

