/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.blocked;

import io.github.ma1uta.matrix.Page;
import io.github.ma1uta.matrix.client.model.event.JoinedMembersResponse;
import io.github.ma1uta.matrix.client.model.event.MembersResponse;
import io.github.ma1uta.matrix.client.model.event.RedactRequest;
import io.github.ma1uta.matrix.client.model.event.SendEventResponse;
import io.github.ma1uta.matrix.client.rest.blocked.EventApi;
import io.github.ma1uta.matrix.event.Event;
import io.github.ma1uta.matrix.event.content.EventContent;
import io.github.ma1uta.matrix.event.message.FormattedBody;
import io.github.ma1uta.matrix.event.message.Notice;
import io.github.ma1uta.matrix.event.message.Text;
import io.github.ma1uta.matrix.impl.Deserializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class EventMethods {
    private final EventApi eventApi;
    private final Deserializer deserializer;

    public EventMethods(RestClientBuilder restClientBuilder) {
        this.eventApi = (EventApi)restClientBuilder.build(EventApi.class);
        Iterator<Deserializer> iterator = ServiceLoader.load(Deserializer.class).iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("Missing Event deserializer. Check that jsonb-support or jackson-support modules enabled.");
        }
        this.deserializer = iterator.next();
    }

    public Event event(String roomId, String eventId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventId, "EventId cannot be empty.");
        return this.eventApi.roomEvent(roomId, eventId);
    }

    public EventContent eventContent(String roomId, String eventType, String stateKey) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventType, "EventType cannot be empty.");
        Objects.requireNonNull(stateKey, "StateKey cannot be empty.");
        try {
            return this.deserializer.deserializeEventContent(this.eventApi.roomEventWithTypeAndState(roomId, eventType, stateKey), eventType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Event> roomState(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        return this.eventApi.roomState(roomId);
    }

    public MembersResponse members(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        return this.eventApi.members(roomId);
    }

    public JoinedMembersResponse joinedMembers(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        return this.eventApi.joinedMembers(roomId);
    }

    public Page<Event> messages(String roomId, String from, String to, String dir, Integer limit, String filter) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(from, "From cannot be empty.");
        Objects.requireNonNull(dir, "Dir cannot be empty.");
        return this.eventApi.messages(roomId, from, to, dir, limit, filter);
    }

    public SendEventResponse sendStateEvent(String roomId, String eventType, String stateKey, EventContent eventContent) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventType, "EventType cannot be empty.");
        Objects.requireNonNull(stateKey, "StateKey cannot be empty.");
        return this.eventApi.sendStateEvent(roomId, eventType, stateKey, eventContent);
    }

    public SendEventResponse sendStateEvent(String roomId, String eventType, EventContent eventContent) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventType, "EventType cannot be empty.");
        return this.eventApi.sendStateEvent(roomId, eventType, eventContent);
    }

    public SendEventResponse sendEvent(String roomId, String eventType, EventContent eventContent) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventType, "EventType cannot be empty.");
        return this.eventApi.sendEvent(roomId, eventType, Long.toString(System.currentTimeMillis()), eventContent);
    }

    public SendEventResponse redact(String roomId, String eventId, String reason) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventId, "EventId cannot be empty.");
        RedactRequest request = new RedactRequest();
        request.setReason(reason);
        return this.eventApi.redact(roomId, eventId, Long.toString(System.currentTimeMillis()), request);
    }

    public SendEventResponse sendMessage(String roomId, String text) {
        return this.sendFormattedMessage(roomId, text, null);
    }

    public SendEventResponse sendNotice(String roomId, String text) {
        return this.sendFormattedNotice(roomId, text, null);
    }

    public SendEventResponse sendFormattedMessage(String roomId, String text, String formattedText) {
        return this.sendFormatted(roomId, text, formattedText, (FormattedBody)new Text());
    }

    public SendEventResponse sendFormattedNotice(String roomId, String text, String formattedText) {
        return this.sendFormatted(roomId, text, formattedText, (FormattedBody)new Notice());
    }

    protected SendEventResponse sendFormatted(String roomId, String text, String formattedText, FormattedBody payload) {
        payload.setBody(text);
        payload.setFormattedBody(formattedText);
        if (formattedText != null) {
            payload.setFormat("org.matrix.custom.html");
        }
        return this.sendEvent(roomId, "m.room.message", (EventContent)payload);
    }
}

