/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.async;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.model.report.ReportRequest;
import io.github.ma1uta.matrix.client.rest.async.ReportApi;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class ReportAsyncMethods {
    private final ReportApi reportApi;

    public ReportAsyncMethods(RestClientBuilder restClientBuilder) {
        this.reportApi = (ReportApi)restClientBuilder.build(ReportApi.class);
    }

    public CompletableFuture<EmptyResponse> report(String roomId, String eventId, String reason, Integer score) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(eventId, "EventId cannot be empty.");
        Objects.requireNonNull(reason, "Reason cannot be empty.");
        Objects.requireNonNull(score, "Score cannot be empty.");
        ReportRequest request = new ReportRequest();
        request.setReason(reason);
        request.setScore(score);
        return this.reportApi.report(roomId, eventId, request).toCompletableFuture();
    }
}

