/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.async;

import io.github.ma1uta.matrix.client.ContentUriModel;
import io.github.ma1uta.matrix.client.model.content.ContentConfig;
import io.github.ma1uta.matrix.client.model.content.ContentUri;
import io.github.ma1uta.matrix.client.rest.async.ContentApi;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class ContentAsyncMethods {
    private final ContentApi contentApi;
    private static final Pattern CONTENT_DISPOSITION = Pattern.compile("filename=\"?(.*)\"?");

    public ContentAsyncMethods(RestClientBuilder restClientBuilder) {
        this.contentApi = (ContentApi)restClientBuilder.build(ContentApi.class);
    }

    public CompletableFuture<ContentUri> upload(InputStream inputStream, String filename, String contentType) {
        return this.contentApi.upload(inputStream, filename, contentType).toCompletableFuture();
    }

    public CompletableFuture<Content> download(String contentUri, Boolean allowRemote) {
        Objects.requireNonNull(contentUri, "ContentUri cannot be empty.");
        ContentUriModel uriModel = ContentUriModel.valueOf(contentUri);
        return this.download(uriModel.getServer(), uriModel.getMediaId(), allowRemote).toCompletableFuture();
    }

    public CompletableFuture<Content> download(String serverName, String mediaId, Boolean allowRemote) {
        Objects.requireNonNull(serverName, "ServerName cannot be empty.");
        Objects.requireNonNull(mediaId, "MediaId cannot be empty.");
        return this.contentApi.download(serverName, mediaId, allowRemote).toCompletableFuture().thenApply(ContentAsyncMethods::toContent);
    }

    public CompletableFuture<Content> downloadFile(String contentUri, String filename, Boolean allowRemote) {
        Objects.requireNonNull(contentUri, "ContentUri cannot be empty.");
        ContentUriModel uriModel = ContentUriModel.valueOf(contentUri);
        return this.downloadFile(uriModel.getServer(), uriModel.getMediaId(), filename, allowRemote);
    }

    public CompletableFuture<Content> downloadFile(String serverName, String mediaId, String filename, Boolean allowRemote) {
        Objects.requireNonNull(serverName, "ServerName cannot be empty.");
        Objects.requireNonNull(mediaId, "MediaId cannot be empty.");
        return this.contentApi.downloadFile(serverName, mediaId, filename, allowRemote).toCompletableFuture().thenApply(ContentAsyncMethods::toContent);
    }

    public CompletableFuture<Thumbnail> thumbnail(String contentUri, Long width, Long height, String method, Boolean allowRemote) {
        Objects.requireNonNull(contentUri, "ContentUri cannot be empty.");
        ContentUriModel uriModel = ContentUriModel.valueOf(contentUri);
        return this.contentApi.thumbnail(uriModel.getServer(), uriModel.getMediaId(), width, height, method, allowRemote).toCompletableFuture().thenApply(ContentAsyncMethods::toThumbnail);
    }

    public CompletableFuture<Thumbnail> thumbnail(String serverName, String mediaId, Long width, Long height, String method, Boolean allowRemote) {
        Objects.requireNonNull(serverName, "ServerName cannot be empty.");
        Objects.requireNonNull(mediaId, "MediaId cannot be empty.");
        return this.contentApi.thumbnail(serverName, mediaId, width, height, method, allowRemote).toCompletableFuture().thenApply(ContentAsyncMethods::toThumbnail);
    }

    public CompletableFuture<Map<String, String>> previewInfo(String url, String ts) {
        Objects.requireNonNull(url, "Url cannot be empty.");
        return this.contentApi.previewUrl(url, ts).toCompletableFuture();
    }

    public CompletableFuture<ContentConfig> getUploadSize() {
        return this.contentApi.config().toCompletableFuture();
    }

    public static Content toContent(Response response) {
        String contentDisposition = response.getHeaderString("Content-Disposition");
        Matcher matcher = CONTENT_DISPOSITION.matcher(contentDisposition);
        String filename = matcher.find() ? matcher.group(1) : contentDisposition;
        String contentType = response.getHeaderString("Content-Type");
        return new Content((InputStream)response.readEntity(InputStream.class), filename, contentType);
    }

    public static Thumbnail toThumbnail(Response response) {
        String contentType = response.getHeaderString("Content-Type");
        return new Thumbnail((InputStream)response.readEntity(InputStream.class), contentType);
    }

    public static class Content {
        private final InputStream inputStream;
        private final String filename;
        private final String contentType;

        public Content(InputStream inputStream, String filename, String contentType) {
            this.inputStream = inputStream;
            this.filename = filename;
            this.contentType = contentType;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getContentType() {
            return this.contentType;
        }
    }

    public static class Thumbnail {
        private final InputStream inputStream;
        private final String contentType;

        public Thumbnail(InputStream inputStream, String contentType) {
            this.inputStream = inputStream;
            this.contentType = contentType;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

