/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods.async;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.model.auth.Identifier;
import io.github.ma1uta.matrix.client.model.auth.LoginRequest;
import io.github.ma1uta.matrix.client.model.auth.LoginResponse;
import io.github.ma1uta.matrix.client.model.auth.SupportedLoginResponse;
import io.github.ma1uta.matrix.client.model.auth.UserIdentifier;
import io.github.ma1uta.matrix.client.rest.async.AuthApi;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthAsyncMethods {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthAsyncMethods.class);
    private final Function<LoginResponse, LoginResponse> afterLogin;
    private final Function<EmptyResponse, EmptyResponse> afterLogout;
    private final AuthApi authApi;

    public AuthAsyncMethods(RestClientBuilder restClientBuilder, Function<LoginResponse, LoginResponse> afterLogin, Function<EmptyResponse, EmptyResponse> afterLogout) {
        this.authApi = (AuthApi)restClientBuilder.build(AuthApi.class);
        this.afterLogin = afterLogin;
        this.afterLogout = afterLogout;
    }

    public CompletableFuture<LoginResponse> login(String login, char[] password) {
        LOGGER.debug("Login with username: ''{}'' and password: ''<redacted>''", (Object)login);
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setType("m.login.password");
        UserIdentifier identifier = new UserIdentifier();
        identifier.setUser(login);
        loginRequest.setIdentifier((Identifier)identifier);
        loginRequest.setPassword(password);
        return this.login(loginRequest);
    }

    public CompletableFuture<LoginResponse> login(LoginRequest loginRequest) {
        Objects.requireNonNull(loginRequest.getType(), "Type cannot be empty.");
        return this.authApi.login(loginRequest).thenApply(this.afterLogin).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> logout() {
        return this.authApi.logout().thenApply(this.afterLogout).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> logoutAll() {
        return this.authApi.logoutAll().thenApply(this.afterLogout).toCompletableFuture();
    }

    public CompletableFuture<SupportedLoginResponse> loginTypes() {
        return this.authApi.supportedLoginTypes().toCompletableFuture();
    }
}

