/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client;

import java.util.Objects;

public class ContentUriModel {
    public static final String PREFIX = "mxc://";
    private static final int PREFIX_LENGTH = "mxc://".length();
    public static final String DELIMITER = "/";
    private final String server;
    private final String mediaId;

    public ContentUriModel(String server, String mediaId) {
        Objects.requireNonNull(server, "Server parts must be specified");
        Objects.requireNonNull(mediaId, "Media ID part must be specified");
        this.server = server;
        this.mediaId = mediaId;
    }

    public String getServer() {
        return this.server;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public static ContentUriModel valueOf(String uri) {
        Objects.requireNonNull(uri, "URI must be specified");
        if (!uri.startsWith(PREFIX)) {
            throw new IllegalArgumentException(String.format("%s is not mxc uri, missing schema 'mxc://'", uri));
        }
        int delimiterIndex = uri.indexOf(DELIMITER, PREFIX_LENGTH);
        if (delimiterIndex == -1) {
            throw new IllegalArgumentException(String.format("%s is not mxc uri, unable to split to the server and media id parts", uri));
        }
        return new ContentUriModel(uri.substring(PREFIX_LENGTH, delimiterIndex), uri.substring(delimiterIndex + 1));
    }

    public String toString() {
        return PREFIX + this.server + DELIMITER + this.mediaId;
    }
}

