/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.client.model.room.CreateRoomRequest;
import io.github.ma1uta.matrix.client.model.room.InviteRequest;
import io.github.ma1uta.matrix.client.model.room.JoinRequest;
import io.github.ma1uta.matrix.client.model.room.JoinedRoomsResponse;
import io.github.ma1uta.matrix.client.model.room.KickRequest;
import io.github.ma1uta.matrix.client.model.room.NewVersion;
import io.github.ma1uta.matrix.client.model.room.PublicRoomsRequest;
import io.github.ma1uta.matrix.client.model.room.PublicRoomsResponse;
import io.github.ma1uta.matrix.client.model.room.ReplacementRoom;
import io.github.ma1uta.matrix.client.model.room.RoomId;
import io.github.ma1uta.matrix.client.model.room.RoomResolveResponse;
import io.github.ma1uta.matrix.client.model.room.RoomVisibility;
import io.github.ma1uta.matrix.client.model.room.UnbanRequest;
import io.github.ma1uta.matrix.client.rest.RoomApi;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class RoomMethods {
    private final RoomApi roomApi;

    public RoomMethods(RestClientBuilder restClientBuilder) {
        this.roomApi = (RoomApi)restClientBuilder.build(RoomApi.class);
    }

    public CompletableFuture<RoomId> create(CreateRoomRequest request) {
        return this.roomApi.create(request).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> createAlias(RoomId roomId, String alias) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(alias, "Alias cannot be empty.");
        return this.roomApi.createAlias(alias, roomId).toCompletableFuture();
    }

    public CompletableFuture<RoomResolveResponse> resolveAlias(String alias) {
        Objects.requireNonNull(alias, "Alias cannot be empty.");
        return this.roomApi.resolveAlias(alias).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> delete(String alias) {
        Objects.requireNonNull(alias, "Alias cannot be empty.");
        return this.roomApi.deleteAlias(alias).toCompletableFuture();
    }

    public CompletableFuture<JoinedRoomsResponse> joinedRooms() {
        return this.roomApi.joinedRooms().toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> invite(String roomId, InviteRequest request) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(request.getIdServer(), "IdServer cannot be empty.");
        Objects.requireNonNull(request.getAddress(), "Address cannot be empty.");
        Objects.requireNonNull(request.getMedium(), "Medium cannot be empty.");
        Objects.requireNonNull(request.getUserId(), "UserId cannot be empty.");
        return this.roomApi.invite(roomId, request).toCompletableFuture();
    }

    public CompletableFuture<RoomId> joinById(String roomId, JoinRequest request) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        return this.roomApi.joinById(roomId, request).toCompletableFuture();
    }

    public CompletableFuture<RoomId> joinByIdOrAlias(String idOrAlias, List<String> serverNames, JoinRequest joinRequest) {
        Objects.requireNonNull(idOrAlias, "IdOrAlias cannot be empty.");
        return this.roomApi.joinByIdOrAlias(idOrAlias, serverNames, joinRequest).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> leave(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        return this.roomApi.leave(roomId).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> forget(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        return this.roomApi.forget(roomId).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> kick(String roomId, String userId, String reason) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        KickRequest request = new KickRequest();
        request.setUserId(userId);
        request.setReason(reason);
        return this.roomApi.kick(roomId, request).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> ban(String roomId, String userId, String reason) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        KickRequest request = new KickRequest();
        request.setUserId(userId);
        request.setReason(reason);
        return this.roomApi.ban(roomId, request).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> unban(String roomId, String userId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(userId, "UserId cannot be empty.");
        UnbanRequest request = new UnbanRequest();
        request.setUserId(userId);
        return this.roomApi.unban(roomId, request).toCompletableFuture();
    }

    public CompletableFuture<RoomVisibility> getVisibility(String roomId) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        return this.roomApi.getVisibility(roomId).toCompletableFuture();
    }

    public CompletableFuture<EmptyResponse> setVisibility(String roomId, String visibility) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        RoomVisibility request = new RoomVisibility();
        request.setVisibility(visibility);
        return this.roomApi.setVisibility(roomId, request).toCompletableFuture();
    }

    public CompletableFuture<PublicRoomsResponse> showPublicRooms(Long limit, String since, String server) {
        return this.roomApi.showPublicRooms(limit, since, server).toCompletableFuture();
    }

    public CompletableFuture<PublicRoomsResponse> searchPublicRooms(String server, PublicRoomsRequest request) {
        return this.roomApi.searchPublicRooms(server, request).toCompletableFuture();
    }

    public CompletableFuture<ReplacementRoom> upgrade(String roomId, String newVersion) {
        Objects.requireNonNull(roomId, "RoomId cannot be empty.");
        Objects.requireNonNull(newVersion, "New version cannot be empty.");
        NewVersion request = new NewVersion();
        request.setNewVersion(newVersion);
        return this.roomApi.upgrade(roomId, request).toCompletableFuture();
    }
}

