/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.methods;

import io.github.ma1uta.matrix.client.rest.ThirdPartyProtocolApi;
import io.github.ma1uta.matrix.protocol.Protocol;
import io.github.ma1uta.matrix.protocol.ProtocolLocation;
import io.github.ma1uta.matrix.protocol.ProtocolUser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class ProtocolMethods {
    private final ThirdPartyProtocolApi thirdPartyProtocolApi;

    public ProtocolMethods(RestClientBuilder restClientBuilder) {
        this.thirdPartyProtocolApi = (ThirdPartyProtocolApi)restClientBuilder.build(ThirdPartyProtocolApi.class);
    }

    public CompletableFuture<Map<String, Protocol>> protocols() {
        return this.thirdPartyProtocolApi.protocols().toCompletableFuture();
    }

    public CompletableFuture<Protocol> protocol(String protocol) {
        Objects.requireNonNull(protocol, "Protocol cannot be empty.");
        return this.thirdPartyProtocolApi.protocol(protocol).toCompletableFuture();
    }

    public CompletableFuture<List<ProtocolLocation>> locations(String protocol) {
        Objects.requireNonNull(protocol, "Protocol cannot be empty.");
        return this.thirdPartyProtocolApi.location(protocol).toCompletableFuture();
    }

    public CompletableFuture<List<ProtocolUser>> users(String protocol) {
        Objects.requireNonNull(protocol, "Protocol cannot be empty.");
        return this.thirdPartyProtocolApi.userProtocol(protocol).toCompletableFuture();
    }

    public CompletableFuture<List<ProtocolLocation>> location(String alias) {
        Objects.requireNonNull(alias, "Alias cannot be empty.");
        return this.thirdPartyProtocolApi.location(alias).toCompletableFuture();
    }

    public CompletableFuture<List<ProtocolUser>> user(String userId) {
        Objects.requireNonNull(userId, "userId cannot be empty.");
        return this.thirdPartyProtocolApi.user(userId).toCompletableFuture();
    }
}

