/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.model.filter;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.client.model.filter.EventFilter;
import io.github.ma1uta.matrix.client.model.filter.RoomFilter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="JSON body request for filter api.")
public class FilterData {
    @Schema(description="List of event fields to include. If this list is absent then all fields are included. The entries may include '.' charaters to indicate sub-fields. So ['content.body'] will include the 'body' field of the 'content' object. A literal '.' character in a field name may be escaped using a ''. A server may include more fields than were requested.")
    @JsonbProperty(value="event_fields")
    private List<String> eventFields;
    @Schema(description="The format to use for events. 'client' will return the events in a format suitable for clients. 'federation' will return the raw event as receieved over federation. The default is 'client'.")
    @JsonbProperty(value="event_format")
    private String eventFormat;
    @Schema(description="The presence updates to include.")
    private EventFilter presence;
    @Schema(description="The user account data that isn't associated with rooms to include.")
    @JsonbProperty(value="account_data")
    private EventFilter accountData;
    @Schema(description="Filters to be applied to room data.")
    private RoomFilter room;

    @JsonProperty(value="event_fields")
    public List<String> getEventFields() {
        return this.eventFields;
    }

    public void setEventFields(List<String> eventFields) {
        this.eventFields = eventFields;
    }

    @JsonProperty(value="event_format")
    public String getEventFormat() {
        return this.eventFormat;
    }

    public void setEventFormat(String eventFormat) {
        this.eventFormat = eventFormat;
    }

    public EventFilter getPresence() {
        return this.presence;
    }

    public void setPresence(EventFilter presence) {
        this.presence = presence;
    }

    @JsonProperty(value="account_data")
    public EventFilter getAccountData() {
        return this.accountData;
    }

    public void setAccountData(EventFilter accountData) {
        this.accountData = accountData;
    }

    public RoomFilter getRoom() {
        return this.room;
    }

    public void setRoom(RoomFilter room) {
        this.room = room;
    }

    public static class EventFormat {
        public static final String CLIENT = "client";
        public static final String FEDERATION = "federation";

        protected EventFormat() {
        }
    }
}

