/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.RateLimitedErrorResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.content.ContentConfig;
import io.github.ma1uta.matrix.client.model.content.ContentUri;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.InputStream;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/media/r0")
public interface ContentApi {
    @Operation(summary="Upload some content to the content repository.", responses={@ApiResponse(responseCode="200", description="The MXC URI for the uploaded content.", content={@Content(schema=@Schema(implementation=ContentUri.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Media"})
    @POST
    @RateLimit
    @Secured
    @Path(value="/upload")
    @Produces(value={"application/json"})
    public void upload(@RequestBody(description="The file content") InputStream var1, @Parameter(description="The name of the file being uploaded.") @QueryParam(value="filename") String var2, @Parameter(description="The content type of the file being uploaded") @HeaderParam(value="Content-Type") String var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @Operation(summary="Download content from the content repository.", responses={@ApiResponse(responseCode="200", description="The content that was previously uploaded."), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, tags={"Media"})
    @GET
    @RateLimit
    @Path(value="/download/{serverName}/{mediaId}")
    @Produces(value={"application/octet-stream"})
    public void download(@Parameter(description="The server name from the mxc:// URI (the authoritory component).", required=true) @PathParam(value="serverName") String var1, @Parameter(description="The media ID from the mxc:// URI (the path component).", required=true) @PathParam(value="mediaId") String var2, @Parameter(description="Indicates to the server that it should not attempt to fetch the media if it is deemed remote. This is to prevent routing loops where the server contacts itself. Defaults to true if not provided.") @QueryParam(value="allow_remote") Boolean var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6);

    @Operation(summary="Download content from the content repository as a given filename.", responses={@ApiResponse(responseCode="200", description="The content that was previously uploaded."), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, tags={"Media"})
    @GET
    @RateLimit
    @Path(value="/download/{serverName}/{mediaId}/{fileName}")
    @Produces(value={"application/octet-stream"})
    public void downloadFile(@Parameter(description="The server name from the mxc:// URI (the authoritory component).", required=true) @PathParam(value="serverName") String var1, @Parameter(description="The media ID from the mxc:// URI (the path component).", required=true) @PathParam(value="mediaId") String var2, @Parameter(description="The filename to give in the Content-Disposition.", required=true) @PathParam(value="fileName") String var3, @Parameter(description="Indicates to the server that it should not attempt to fetch the media if it is deemed remote. This is to prevent routing loops where the server contacts itself. Defaults to true if not provided.") @QueryParam(value="allow_remote") Boolean var4, @Context UriInfo var5, @Context HttpHeaders var6, @Suspended AsyncResponse var7);

    @Operation(summary="Download a thumbnail of the content from the content repository.", responses={@ApiResponse(responseCode="200", description="The content that was previously uploaded."), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, tags={"Media"})
    @GET
    @RateLimit
    @Path(value="/thumbnail/{serverName}/{mediaId}")
    @Produces(value={"application/octet-stream"})
    public void thumbnail(@Parameter(description="The server name from the mxc:// URI (the authoritory component).", required=true) @PathParam(value="serverName") String var1, @Parameter(description="The media ID from the mxc:// URI (the path component)", required=true) @PathParam(value="mediaId") String var2, @Parameter(description="The desired width of the thumbnail. The actual thumbnail may not match the size specified.") @QueryParam(value="width") Long var3, @Parameter(description="The desired height of the thumbnail. The actual thumbnail may not match the size specified.") @QueryParam(value="height") Long var4, @Parameter(description="The desired resizing method.", schema=@Schema(allowableValues={"crop", "scale"})) @QueryParam(value="method") String var5, @Parameter(description="Indicates to the server that it should not attempt to fetch the media if it is deemed remote. This is to prevent routing loops where the server contacts itself. Defaults to true if not provided.") @QueryParam(value="allow_remote") Boolean var6, @Context UriInfo var7, @Context HttpHeaders var8, @Suspended AsyncResponse var9);

    @Operation(summary="Get information about a PATH for a client.", responses={@ApiResponse(responseCode="200", description="The content that was previously uploaded.", content={@Content(schema=@Schema(implementation=Map.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Media"})
    @GET
    @RateLimit
    @Secured
    @Path(value="/preview_url")
    @Produces(value={"application/json"})
    public void previewUrl(@Parameter(description="The PATH to get a preview of.", required=true) @QueryParam(value="url") String var1, @Parameter(description="The preferred point in time to return a preview for. The server may return a newer version if it does not have the requested version available.") @QueryParam(value="ts") String var2, @Context UriInfo var3, @Context HttpHeaders var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    @Operation(summary="his endpoint allows clients to retrieve the configuration of the content repository, suchas upload limitations.", description="Clients SHOULD use this as a guide when using content repository endpoints. All values are intentionally left optional. Clients SHOULD follow the advice given in the field description when the field is not available. NOTE: Both clients and server administrators should be aware that proxies between the client and the server may affect the apparent behaviour of content repository APIs, for example, proxies may enforce a lower upload size limit than is advertised by the server on this endpoint.", responses={@ApiResponse(responseCode="200", description="The public content repository configuration for the matrix server.", content={@Content(schema=@Schema(implementation=ContentConfig.class))}), @ApiResponse(responseCode="429", description="This request was rate-limited.", content={@Content(schema=@Schema(implementation=RateLimitedErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Media"})
    @GET
    @RateLimit
    @Secured
    @Path(value="/config")
    @Produces(value={"application/json"})
    public void config(@Context UriInfo var1, @Context HttpHeaders var2, @Suspended AsyncResponse var3, @Context SecurityContext var4);

    public static class Method {
        public static final String CROP = "crop";
        public static final String SCALE = "scale";

        protected Method() {
        }
    }
}

