/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.model.room;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.client.model.room.Invite3pid;
import io.github.ma1uta.matrix.event.Event;
import io.github.ma1uta.matrix.event.content.RoomPowerLevelsContent;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import javax.json.bind.annotation.JsonbProperty;

@Schema(description="JSON body request for creation api.")
public class CreateRoomRequest {
    @Schema(description="A public visibility indicates that the room will be shown in the published room list. A private visibility will hide the room from the published room list. Rooms default to private visibility if this key is not included. NB: This should not be confused with join_rules which also uses the word public.")
    private String visibility;
    @Schema(description="The desired room alias local part. If this is included, a room alias will be created and mapped to the newly created room. The alias will belong on the same homeserver which created the room. For example, if this was set to \"foo\" and sent to the homeserver \"example.com\" the complete room alias would be #foo:example.com.")
    @JsonbProperty(value="room_alias_name")
    private String roomAliasName;
    @Schema(description="If this is included, an m.room.name event will be sent into the room to indicate the name of the room. See Room Events for more information on m.room.name.")
    private String name;
    @Schema(description="If this is included, an m.room.topic event will be sent into the room to indicate the topic for the room. See Room Events for more information on m.room.topic.")
    private String topic;
    @Schema(description="A list of user IDs to invite to the room. This will tell the server to invite everyone in the list to the newly created room.")
    private List<String> invite;
    @Schema(description="A list of objects representing third party IDs to invite into the room.")
    @JsonbProperty(value="invite_3pid")
    private List<Invite3pid> invite3pid;
    @Schema(description="The room version to set for the room. If not provided, the homeserver is to use its configured default. If provided, the homeserver will return a 400 error with the errcode M_UNSUPPORTED_ROOM_VERSION if it does not support the room version.")
    @JsonbProperty(value="room_version")
    private String roomVersion;
    @Schema(description="Extra keys to be added to the content of the m.room.create. The server will clobber the following keys: creator. Future versions of the specification may allow the server to clobber other keys.")
    @JsonbProperty(value="creation_content")
    private Map<String, Object> creationContent;
    @Schema(description="A list of state events to set in the new room. This allows the user to override the default state events set in the new room. The expected format of the state events are an object with type, state_key and content keys set.")
    @JsonbProperty(value="initial_event")
    private List<Event> initialEvent;
    @Schema(description="Convenience parameter for setting various default state events based on a preset.")
    private String preset;
    @Schema(description="This flag makes the server set the is_direct flag on the m.room.member events sent to the users in invite and invite_3pid. See DirectContent Messaging for more information.")
    @JsonbProperty(value="is_direct")
    private Boolean direct;
    @Schema(description="The power level content to override in the default power level event. This object is applied on top of the generated m.room.power_levels event content prior to it being sent to the room. Defaults to overriding nothing.")
    @JsonbProperty(value="power_level_content_override")
    private RoomPowerLevelsContent powerLevelContentOverride;

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    @JsonProperty(value="room_alias_name")
    public String getRoomAliasName() {
        return this.roomAliasName;
    }

    public void setRoomAliasName(String roomAliasName) {
        this.roomAliasName = roomAliasName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public List<String> getInvite() {
        return this.invite;
    }

    public void setInvite(List<String> invite) {
        this.invite = invite;
    }

    @JsonProperty(value="invite_3pid")
    public List<Invite3pid> getInvite3pid() {
        return this.invite3pid;
    }

    public void setInvite3pid(List<Invite3pid> invite3pid) {
        this.invite3pid = invite3pid;
    }

    @JsonProperty(value="room_version")
    public String getRoomVersion() {
        return this.roomVersion;
    }

    public void setRoomVersion(String roomVersion) {
        this.roomVersion = roomVersion;
    }

    @JsonProperty(value="creation_content")
    public Map<String, Object> getCreationContent() {
        return this.creationContent;
    }

    public void setCreationContent(Map<String, Object> creationContent) {
        this.creationContent = creationContent;
    }

    @JsonProperty(value="initial_event")
    public List<Event> getInitialEvent() {
        return this.initialEvent;
    }

    public void setInitialEvent(List<Event> initialEvent) {
        this.initialEvent = initialEvent;
    }

    public String getPreset() {
        return this.preset;
    }

    public void setPreset(String preset) {
        this.preset = preset;
    }

    @JsonProperty(value="is_direct")
    public Boolean getDirect() {
        return this.direct;
    }

    public void setDirect(Boolean direct) {
        this.direct = direct;
    }

    @JsonProperty(value="power_level_content_override")
    public RoomPowerLevelsContent getPowerLevelContentOverride() {
        return this.powerLevelContentOverride;
    }

    public void setPowerLevelContentOverride(RoomPowerLevelsContent powerLevelContentOverride) {
        this.powerLevelContentOverride = powerLevelContentOverride;
    }
}

