/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.tag.Tags;
import io.github.ma1uta.matrix.events.nested.TagInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Tag", description="Users can add tags to rooms. Tags are short strings used to label rooms, e.g. \"work\", \"family\". A room may have multiple tags. Tags are only visible to the user that set them but are shared across all their devices.")
@Path(value="/_matrix/client/r0/user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface TagApi {
    @ApiOperation(value="List the tags set by a user on a room.", response=Tags.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The list of tags for the user for the room.")})
    @GET
    @Secured
    @Path(value="/{userId}/rooms/{roomId}/tags")
    public void showTags(@ApiParam(value="The id of the user to get tags for. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") String var1, @ApiParam(value="The id of the room to get tags for.", required=true) @PathParam(value="roomId") String var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Add a tag to the room.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The tag was successfully added.")})
    @PUT
    @Secured
    @Path(value="/{userId}/rooms/{roomId}/tags/{tag}")
    public void addTag(@ApiParam(value="The id of the user to add a tag for. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") String var1, @ApiParam(value="The id of the room to add a tag to.", required=true) @PathParam(value="roomId") String var2, @ApiParam(value="The tag to add.", required=true) @PathParam(value="tag") String var3, @ApiParam(value="TagInfo data.") TagInfo var4, @Context HttpServletRequest var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    @ApiOperation(value="Remove a tag from the room.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The tag was successfully removed.")})
    @DELETE
    @Secured
    @Path(value="/{userId}/rooms/{roomId}/tags/{tag}")
    public void deleteTag(@ApiParam(value="The id of the user to remove a tag for. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") String var1, @ApiParam(value="The id of the room to remove a tag from.", required=true) @PathParam(value="roomId") String var2, @ApiParam(value="The tag to remove.", required=true) @PathParam(value="tag") String var3, @Context HttpServletRequest var4, @Suspended AsyncResponse var5, @Context SecurityContext var6);

    public static class Tag {
        public static final String FAVOURITE = "m.favourite";
        public static final String LOWPRIOORITY = "m.lowpriority";

        protected Tag() {
        }
    }
}

