/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.profile.AvatarUrl;
import io.github.ma1uta.matrix.client.model.profile.DisplayName;
import io.github.ma1uta.matrix.client.model.profile.Profile;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Profile", description="Profiles.")
@Path(value="/_matrix/client/r0/profile")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ProfileApi {
    @ApiOperation(value="his API sets the given user's display name. You must have permission to set this user's display name, e.g. you need to have their access_token.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The display name was set."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @PUT
    @RateLimit
    @Secured
    @Path(value="/{userId}/displayname")
    public void setDisplayName(@ApiParam(value="The user whose display name to set.", required=true) @PathParam(value="userId") String var1, @ApiParam(value="JSON body request.") DisplayName var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Get the user's display name. This API may be used to fetch the user's own displayname or to query the name of other users; either locally or on remote homeservers.", response=DisplayName.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The display name for this user."), @ApiResponse(code=404, message="There is no display name for this user or this user does not exist.")})
    @GET
    @Path(value="/{userId}/displayname")
    public void showDisplayName(@ApiParam(value="The user whose display name to get.", required=true) @PathParam(value="userId") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="This API sets the given user's avatar URL. You must have permission to set this user's avatar URL, e.g. you need to have their access_token.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The avatar URL was set."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @PUT
    @RateLimit
    @Secured
    @Path(value="/{userId}/avatar_url")
    public void setAvatarUrl(@ApiParam(value="The user whose avatar URL to set.", required=true) @PathParam(value="userId") String var1, @ApiParam(value="JSON body request") AvatarUrl var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Get the user's avatar URL. This API may be used to fetch the user's own avatar URL or to query the URL of other users;  either locally or on remote homeservers.", response=AvatarUrl.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The avatar URL for this user."), @ApiResponse(code=404, message="There is no avatar URL for this user or this user does not exist.")})
    @GET
    @Path(value="/{userId}/avatar_url")
    public void showAvatarUrl(@ApiParam(value="The user whose avatar URL to get.", required=true) @PathParam(value="userId") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="Get the combined profile information for this user. This API may be used to fetch the user's own profile information or other users; either locally or on remote homeservers. This API may return keys which are not limited to displayname or avatar_url.", response=Profile.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The avatar URL for this user."), @ApiResponse(code=404, message="There is no profile information for this user or this user does not exist.")})
    @GET
    @Path(value="/{userId}")
    public void profile(@ApiParam(value="The user whose profile information to get.", required=true) @PathParam(value="userId") String var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);
}

