/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.filter.FilterData;
import io.github.ma1uta.matrix.client.model.filter.FilterResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Filter", description="Filters can be created on the server and can be passed as as a parameter to APIs which return events. These filters alter the data returned from those APIs. Not all APIs accept filters.")
@Path(value="/_matrix/client/r0/user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface FilterApi {
    @ApiOperation(value="Uploads a new filter definition to the homeserver.", notes="Returns a filter ID that may be used in future requests to restrict which events are returned to the client.", response=FilterResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The filter was created.")})
    @POST
    @Secured
    @Path(value="/{userId}/filter")
    public void uploadFilter(@ApiParam(value="The id of the user uploading the filter. The access token must be authorized to make requests for this user id.", required=true) @PathParam(value="userId") String var1, @ApiParam(value="JSON body parameters") FilterData var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Download a filter.", response=FilterData.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The filter definition."), @ApiResponse(code=404, message="Unknown filter.")})
    @GET
    @Secured
    @Path(value="/{userId}/filter/{filterId}")
    public void getFilter(@ApiParam(value="The user ID to download a filter for.", required=true) @PathParam(value="userId") String var1, @ApiParam(value="The filter ID to download.", required=true) @PathParam(value="filterId") String var2, @Context HttpServletRequest var3, @Suspended AsyncResponse var4, @Context SecurityContext var5);
}

