/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.RateLimit;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.auth.LoginRequest;
import io.github.ma1uta.matrix.client.model.auth.LoginResponse;
import io.github.ma1uta.matrix.client.model.auth.SupportedLoginResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Authentication", description="A client can obtain access tokens using the /login API")
@Path(value="/_matrix/client/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface AuthApi {
    @ApiOperation(value="Gets the homeserver's supported login types to authenticate users.", notes="Clients should pick one of these and supply it as the type when logging in.", response=SupportedLoginResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The login types the homeserver supports."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @GET
    @RateLimit
    @Path(value="/login")
    public void supportedLoginTypes(@Context HttpServletRequest var1, @Suspended AsyncResponse var2);

    @ApiOperation(value="Authenticates the user, and issues an access token they can use to authorize themself in subsequent requests", notes="If the client does not supply a device_id, the server must auto-generate one. The returned access token must be associated with the device_id supplied by the client or generated by the server. The server may invalidate any access token previously associated with that device", response=LoginResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The user has been authenticated"), @ApiResponse(code=400, message="Part of the request was invalid. For example, the login type may not be recognised"), @ApiResponse(code=401, message="The login attempt failed. For example, the password may have been incorrect."), @ApiResponse(code=429, message="This request was rate-limited.")})
    @POST
    @RateLimit
    @Path(value="/login")
    public void login(@ApiParam(value="login request.") LoginRequest var1, @Context HttpServletRequest var2, @Suspended AsyncResponse var3);

    @ApiOperation(value="Invalidates an existing access token, so that it can no longer be used for authorization.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The access token used in the request was succesfully invalidated")})
    @POST
    @Secured
    @Path(value="/logout")
    public void logout(@Context HttpServletRequest var1, @Suspended AsyncResponse var2, @Context SecurityContext var3);

    @ApiOperation(value="Invalidates all access tokens for a user, so that they can no longer be used for authorization. This includes the access token that made this request", notes="This endpoint does not require UI authorization because UI authorization is designed to protect against attacks where the someone gets hold of a single access token then takes over the account. This endpoint invalidates all access tokens for the user, including the token used in the request, and therefore the attacker is unable to take over the account in this way.", response=EmptyResponse.class, authorizations={@Authorization(value="Authorization")})
    @ApiResponses(value={@ApiResponse(code=200, message="The user's access tokens were succesfully invalidated")})
    @POST
    @Secured
    @Path(value="/logout/all")
    public void logoutAll(@Context HttpServletRequest var1, @Suspended AsyncResponse var2, @Context SecurityContext var3);

    public static class AuthType {
        public static final String PASSWORD = "m.login.password";
        public static final String RECAPTCHA = "m.login.recaptcha";
        public static final String OAUTH2 = "m.login.oauth2";
        public static final String EMAIL_IDENTITY = "m.login.email.identity";
        public static final String TOKEN = "m.login.token";
        public static final String DUMMY = "m.login.dummy";
        public static final String APPLICATION_SERVICE = "m.login.application_service";

        protected AuthType() {
        }
    }
}

