/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.model.encryption;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.ma1uta.matrix.client.model.encryption.UnsignedDeviceInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;

@ApiModel(description="Device keys.")
public class DeviceKeys {
    @ApiModelProperty(name="user_id", value="The ID of the user the device belongs to. Must match the user ID used when logging in.", required=true)
    @JsonProperty(value="user_id")
    private String userId;
    @ApiModelProperty(name="device_id", value="The ID of the device these keys belong to. Must match the device ID used when logging in.", required=true)
    @JsonProperty(value="device_id")
    private String deviceId;
    @ApiModelProperty(value="The encryption algorithms supported by this device.", required=true)
    private List<String> algorithms;
    @ApiModelProperty(value="Public identity keys. The names of the properties should be in the format &lt;algorithm&gt;:&lt;device_id&gt;. The keys themselves should be encoded as specified by the key algorithm.", required=true)
    private Map<String, String> keys;
    @ApiModelProperty(value="Signatures for the device key object. A map from user ID, to a map from (algorithm):(device_id) to the signature.", required=true)
    private Map<String, Map<String, String>> signatures;
    @ApiModelProperty(value="Additional data added to the device key information by intermediate servers, and not covered by the signatures.")
    private UnsignedDeviceInfo unsignedDeviceInfo;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public List<String> getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(List<String> algorithms) {
        this.algorithms = algorithms;
    }

    public Map<String, String> getKeys() {
        return this.keys;
    }

    public void setKeys(Map<String, String> keys) {
        this.keys = keys;
    }

    public Map<String, Map<String, String>> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(Map<String, Map<String, String>> signatures) {
        this.signatures = signatures;
    }

    public UnsignedDeviceInfo getUnsignedDeviceInfo() {
        return this.unsignedDeviceInfo;
    }

    public void setUnsignedDeviceInfo(UnsignedDeviceInfo unsignedDeviceInfo) {
        this.unsignedDeviceInfo = unsignedDeviceInfo;
    }
}

