/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.Event;
import io.github.ma1uta.matrix.Page;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.event.JoinedMembersResponse;
import io.github.ma1uta.matrix.client.model.event.MembersResponse;
import io.github.ma1uta.matrix.client.model.event.RedactRequest;
import io.github.ma1uta.matrix.client.model.event.SendEventResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Event", description="There are several APIs provided to GET events for a room.")
@Path(value="/_matrix/client/r0/rooms")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface EventApi {
    @ApiOperation(value="Get a single event based on roomId/eventId. You must have permission to retrieve this event e.g. by being a member in the room for this event.", response=Event.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The full event."), @ApiResponse(code=404, message="The event was not found or you do not have permission to read this event.")})
    @GET
    @Secured
    @Path(value="/{roomId}/event/{eventId}")
    public Event singleEvent(@ApiParam(value="The ID of the room the event is in.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="The event ID to get.", required=true) @PathParam(value="eventId") String var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Looks up the contents of a state event in a room. If the user is joined to the room then the state is taken from the current state of the room. If the user has left the room then the state is taken from the state of the room when they left.", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The content of the state event."), @ApiResponse(code=403, message="You aren't a member of the room and weren't previously a member of the room."), @ApiResponse(code=404, message="The room has no state with the given type or key.")})
    @GET
    @Secured
    @Path(value="/{roomId}/state/{eventType}/{stateKey}")
    public Map<String, Object> eventsForRoomWithTypeAndState(@ApiParam(value="The room to look up the state in.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="The type of state to look up.", required=true) @PathParam(value="eventType") String var2, @ApiParam(value="The key of the state to look up.", required=true) @PathParam(value="stateKey") String var3, @Context HttpServletRequest var4, @Context HttpServletResponse var5, @Context SecurityContext var6);

    @ApiOperation(value="Looks up the contents of a state event in a room. If the user is joined to the room then the state is taken from the current state of the room. If the user has left the room then the state is taken from the state of the room when they left.", notes="This looks up the state event with the empty state key.", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The content of the state event."), @ApiResponse(code=403, message="You aren't a member of the room and weren't previously a member of the room."), @ApiResponse(code=404, message="The room has no state with the given type or key.")})
    @GET
    @Secured
    @Path(value="/{roomId}/state/{eventType}")
    public Map<String, Object> eventsForRoomWithType(@ApiParam(value="The room to look up the state in.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="The type of state to look up.", required=true) @PathParam(value="eventType") String var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Get the state events for the current state of a room.", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The current state of the room."), @ApiResponse(code=403, message="You aren't a member of the room and weren't previously a member of the room.")})
    @GET
    @Secured
    @Path(value="/{roomId}/state")
    public List<Event> eventsForRoom(@ApiParam(value="The room to look up the state for.", required=true) @PathParam(value="roomId") String var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="Get the list of members for this room.", response=MembersResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="A list of members of the room. If you are joined to the room then this will be the current members of the room. If you have left the room then this will be the members of the room when you left."), @ApiResponse(code=403, message="You aren't a member of the room and weren't previously a member of the room.")})
    @GET
    @Secured
    @Path(value="/{roomId}/members")
    public MembersResponse members(@ApiParam(value="The room to get the member events for.", required=true) @PathParam(value="roomId") String var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="This API returns a map of MXIDs to member info objects for members of the room.", notes="The current user must be in the room for it to work, unless it is an Application Service in which case any of the AS's users must be in the room. This API is primarily for Application Services and should be faster to respond than/members as it can be implemented more efficiently on the server.", response=JoinedMembersResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="A map of MXID to room member objects."), @ApiResponse(code=403, message="You aren't a member of the room.")})
    @GET
    @Secured
    @Path(value="/{roomId}/joined_members")
    public JoinedMembersResponse joinedMembers(@ApiParam(value="The room to get the members of.", required=true) @PathParam(value="roomId") String var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="This API returns a list of message and state events for a room.", notes="It uses pagination query parameters to paginate history in the room.", response=Page.class)
    @ApiResponses(value={@ApiResponse(code=200, message="A list of messages with a new token to request more."), @ApiResponse(code=403, message="You aren't a member of the room.")})
    @GET
    @Secured
    @Path(value="/{roomId}/messages")
    public Page<Event> messages(@ApiParam(value="The room to get events from.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="The token to start returning events from. This token can be obtained from a prev_batch token returned for each room by the sync API, or from a start or end token returned by a previous request to this endpoint.", required=true) @QueryParam(value="from") String var2, @ApiParam(value="The token to stop returning events at. This token can be obtained from a prev_batch token returned for each room by the sync endpoint, or from a start or end token returned by a previous request to this endpoint.") @QueryParam(value="to") String var3, @ApiParam(value="The direction to return events from.", required=true, allowableValues="['b','f]") @QueryParam(value="dir") String var4, @ApiParam(value="The maximum number of events to return. Default: 10.") @QueryParam(value="limit") Integer var5, @ApiParam(value="A JSON RoomEventFilter to filter returned events with.") @QueryParam(value="filter") String var6, @Context HttpServletRequest var7, @Context HttpServletResponse var8, @Context SecurityContext var9);

    @ApiOperation(value="State events can be sent using this endpoint.", notes="These events will be overwritten if (room id), (event type) and (state key) all match. Requests to this endpoint cannot use transaction IDs like other PUT paths because they cannot be differentiated from the state_key. Furthermore, POST is unsupported on state paths. The body of the request should be the content object of the event; the fields in this object will vary depending on the type of event.See Room Events for the m.event specification.", response=SendEventResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="An ID for the sent event.")})
    @PUT
    @Secured
    @Path(value="/{roomId}/state/{eventType}/{stateKey}")
    public SendEventResponse sendEventWithTypeAndState(@ApiParam(value="The room to set the state in.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="The type of event to send.", required=true) @PathParam(value="eventType") String var2, @ApiParam(value="The state_key for the state to send. Defaults to the empty string.", required=true) @PathParam(value="stateKey") String var3, @ApiParam(value="event") Map<String, Object> var4, @Context HttpServletRequest var5, @Context HttpServletResponse var6, @Context SecurityContext var7);

    @ApiOperation(value="State events can be sent using this endpoint.", notes="This endpoint is equivalent to calling /rooms/{roomId}/state/{eventType}/{stateKey} with an empty stateKey. Previous state events with matching (roomId) and (eventType), and empty (stateKey), will be overwritten. Requests to this endpoint cannot use transaction IDs like other PUT paths because they cannot be differentiated from the state_key. Furthermore, POST is unsupported on state paths. The body of the request should be the content object of the event; the fields in this object will vary depending on the type of event. See Room Events for the m.event specification.", response=SendEventResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="An ID for the sent event.")})
    @PUT
    @Secured
    @Path(value="/{roomId}/state/{eventType}")
    public SendEventResponse sendEventWithType(@ApiParam(value="The room to set the state in.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="The type of event to send.", required=true) @PathParam(value="eventType") String var2, @ApiParam(value="Event") Map<String, Object> var3, @Context HttpServletRequest var4, @Context HttpServletResponse var5, @Context SecurityContext var6);

    @ApiOperation(value="This endpoint is used to send a message event to a room.", notes="Message events allow access to historical events and pagination, making them suited for \"once-off\" activity in a room. The body of the request should be the content object of the event; the fields in this object will vary depending on the type of event. See Room Events for the m. event specification.", response=SendEventResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="An ID for the sent event.")})
    @PUT
    @Secured
    @Path(value="/{roomId}/send/{eventType}/{txnId}")
    public SendEventResponse sendEvent(@ApiParam(value="The room to send the event to.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="The type of event to send.", required=true) @PathParam(value="eventType") String var2, @ApiParam(value="The transaction ID for this event. Clients should generate an ID unique across requests with the same access token; it will be used by the server to ensure idempotency of requests.", required=true) @PathParam(value="txnId") String var3, @ApiParam(value="Event") Map<String, Object> var4, @Context HttpServletRequest var5, @Context HttpServletResponse var6, @Context SecurityContext var7);

    @ApiOperation(value="Strips all information out of an event which isn't critical to the integrity of the server-side representation of the room.", notes="This cannot be undone. Users may redact their own events, and any user with a power level greater than or equal to the redact power level of the room may redact events there.", response=SendEventResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="An ID for the redaction event.")})
    @PUT
    @Secured
    @Path(value="/{roomId}/redact/{eventId}/{txnId}")
    public SendEventResponse redact(@ApiParam(value="The room from which to redact the event.", required=true) @PathParam(value="roomId") String var1, @ApiParam(value="The ID of the event to redact.", required=true) @PathParam(value="eventId") String var2, @ApiParam(value="The transaction ID for this event. Clients should generate a unique ID; it will be used by the server to ensure idempotency of requests.", required=true) @PathParam(value="txnId") String var3, @ApiParam(value="The reason for the event being redacted.") RedactRequest var4, @Context HttpServletRequest var5, @Context HttpServletResponse var6, @Context SecurityContext var7);
}

