/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.device.Device;
import io.github.ma1uta.matrix.client.model.device.DeviceDeleteRequest;
import io.github.ma1uta.matrix.client.model.device.DeviceUpdateRequest;
import io.github.ma1uta.matrix.client.model.device.DevicesDeleteRequest;
import io.github.ma1uta.matrix.client.model.device.DevicesResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Api(value="Device", description="Clients that implement this module should offer the user a list of registered devices, as well as the means to update their display names. Clients should also allow users to delete disused devices.")
@Path(value="/_matrix/client/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface DeviceApi {
    @ApiOperation(value="Gets information about all devices for the current user.", response=DevicesResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="A list of all registered devices for this user.")})
    @GET
    @Secured
    @Path(value="/devices")
    public DevicesResponse devices(@Context HttpServletRequest var1, @Context HttpServletResponse var2, @Context SecurityContext var3);

    @ApiOperation(value="Gets information on a single device, by device id.", response=Device.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Device information."), @ApiResponse(code=404, message="The current user has no device with the given ID.")})
    @GET
    @Secured
    @Path(value="/devices/{deviceId}")
    public Device device(@ApiParam(value="The device to retrieve", required=true) @PathParam(value="deviceId") String var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3, @Context SecurityContext var4);

    @ApiOperation(value="Updates the metadata on the given device.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The device was successfully updated."), @ApiResponse(code=404, message="The current user has no device with the given ID.")})
    @PUT
    @Secured
    @Path(value="/devices/{deviceId}")
    public EmptyResponse updateDevice(@ApiParam(value="The device to update.", required=true) @PathParam(value="deviceId") String var1, @ApiParam(value="The new display name for this device. If not given, the display name is unchanged.") DeviceUpdateRequest var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Deletes the given device, and invalidates any access token associated with it.", notes="This API endpoint uses the User-Interactive Authentication API.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The device was successfully removed, or had been removed previously."), @ApiResponse(code=401, message="The homeserver requires additional authentication information.")})
    @DELETE
    @Secured
    @Path(value="/devices/{deviceId}")
    public EmptyResponse deleteDevice(@ApiParam(value="The device to delete", required=true) @PathParam(value="deviceId") String var1, @ApiParam(value="Additional authentication information for the user-interactive authentication API.") DeviceDeleteRequest var2, @Context HttpServletRequest var3, @Context HttpServletResponse var4, @Context SecurityContext var5);

    @ApiOperation(value="Deletes the given devices, and invalidates any access token associated with them.", notes="This API endpoint uses the User-Interactive Authentication API.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The devices were successfully removed, or had been removed previously."), @ApiResponse(code=401, message="The homeserver requires additional authentication information.")})
    @POST
    @Secured
    @Path(value="/delete_devices")
    public EmptyResponse deleteDevices(@ApiParam(value="JSON body request") DevicesDeleteRequest var1, @Context HttpServletRequest var2, @Context HttpServletResponse var3, @Context SecurityContext var4);
}

