/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.client.api;

import io.github.ma1uta.matrix.ErrorResponse;
import io.github.ma1uta.matrix.Page;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.client.model.sync.SyncResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="/_matrix/client/r0")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface SyncApi {
    @Operation(summary="Synchronise the client's state with the latest state on the server. Clients use this API when they first log in to get an initial snapshot of the state on the server, and then continue to call this API to get incremental deltas to the state, and to receive new messages.", responses={@ApiResponse(responseCode="200", description="The initial snapshot or delta for the client to use to update their state.", content={@Content(schema=@Schema(implementation=SyncResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @GET
    @Secured
    @Path(value="/sync")
    public void sync(@Parameter(description="The ID of a filter created using the filter API or a filter JSON object encoded as a string. The server will detect whether it is an ID or a JSON object by whether the first character is a \"{\" open brace. Passing the JSON inline is best suited to one off requests. Creating a filter using the filter API is recommended for clients that reuse the same filter multiple times, for example in long poll requests.") @QueryParam(value="filter") String var1, @Parameter(description="A point in time to continue a sync from.") @QueryParam(value="since") String var2, @Parameter(description="Controls whether to include the full state for all rooms the user is a member of.") @QueryParam(value="full_state") Boolean var3, @Parameter(description="Controls whether the client is automatically marked as online by polling this API. If this parameter is omitted then the client is automatically marked as online when it uses this API. Otherwise if the parameter is set to \"offline\" then the client is not marked as being online when it uses this API.", schema=@Schema(allowableValues={"offline"})) @QueryParam(value="set_presence") String var4, @Parameter(description="The maximum time to wait, in milliseconds, before returning this request. If no events (or other data) become available before this time elapses, the server will return a response with empty fields.") @QueryParam(value="timeout") Long var5, @Context UriInfo var6, @Context HttpHeaders var7, @Suspended AsyncResponse var8, @Context SecurityContext var9);

    @Operation(summary="This will listen for new events related to a particular room and return them to the caller. This will block until an event is received, or until the timeout is reached.", responses={@ApiResponse(responseCode="200", description="The events received, which may be none.", content={@Content(schema=@Schema(implementation=Page.class))}), @ApiResponse(responseCode="400", description="Bad pagination from parameter.", content={@Content(schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="accessToken")}, tags={"Room participation"})
    @GET
    @Secured
    @Path(value="/events")
    public void events(@Parameter(description="The token to stream from. This token is either from a previous request to this API or from the initial sync API.") @QueryParam(value="from") String var1, @Parameter(description="The maximum time in milliseconds to wait for an event.") @QueryParam(value="timeout") Long var2, @Parameter(description="The room ID for which events should be returned.") @QueryParam(value="room_id") String var3, @Context UriInfo var4, @Context HttpHeaders var5, @Suspended AsyncResponse var6, @Context SecurityContext var7);

    public static class Presence {
        public static final String OFFLINE = "offline";

        protected Presence() {
        }
    }
}

