/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.bot;

import io.github.ma1uta.matrix.bot.Bot;
import io.github.ma1uta.matrix.bot.BotConfig;
import io.github.ma1uta.matrix.bot.BotDao;
import io.github.ma1uta.matrix.bot.Command;
import io.github.ma1uta.matrix.bot.Context;
import io.github.ma1uta.matrix.bot.LoopState;
import io.github.ma1uta.matrix.bot.PersistentService;
import io.github.ma1uta.matrix.client.AppServiceClient;
import io.github.ma1uta.matrix.client.MatrixClient;
import io.github.ma1uta.matrix.client.RequestParams;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.event.Event;
import io.github.ma1uta.matrix.event.RoomEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationServiceBot<C extends BotConfig, D extends BotDao<C>, S extends PersistentService<D>, E>
extends Bot<C, D, S, E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationServiceBot.class);

    public ApplicationServiceBot(RequestFactory factory, String asToken, boolean exitOnEmptyRooms, C config, S service, List<Class<? extends Command<C, D, S, E>>> commandsClasses) {
        super(factory, asToken, exitOnEmptyRooms, config, service, commandsClasses);
    }

    @Override
    protected Context<C, D, S, E> init(RequestFactory factory, String asToken, C config, S service) {
        AppServiceClient matrixClient = new AppServiceClient(factory, new RequestParams().userId(((BotConfig)config).getUserId()).accessToken(asToken));
        Context context = new Context((MatrixClient)matrixClient, service, this);
        context.setConfig(config);
        return context;
    }

    @Override
    public void init() {
        if (this.getInitAction() != null) {
            this.getContext().runInTransaction((context, dao) -> this.getInitAction().accept(context, dao));
        }
    }

    public void send(RoomEvent event) {
        LoopState state = LoopState.RUN;
        LOGGER.debug("State: {}", (Object)state);
        switch (((BotConfig)this.getContext().getConfig()).getState()) {
            case NEW: {
                state = this.newState();
                break;
            }
            case REGISTERED: {
                HashMap<String, List<Event>> eventMap = new HashMap<String, List<Event>>();
                eventMap.put(event.getRoomId(), Collections.singletonList(event));
                state = this.registeredState(eventMap);
                break;
            }
            case JOINED: {
                state = this.processJoinedRoom(event.getRoomId(), Collections.singletonList(event));
                break;
            }
            case DELETED: {
                state = this.deletedState();
                break;
            }
            default: {
                LOGGER.error("Unknown state: " + (Object)((Object)((BotConfig)this.getContext().getConfig()).getState()));
            }
        }
        if (LoopState.EXIT.equals((Object)state)) {
            this.getContext().getShutdownListeners().forEach(Supplier::get);
        }
    }
}

