/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.bot;

import io.github.ma1uta.matrix.bot.Bot;
import io.github.ma1uta.matrix.bot.BotConfig;
import io.github.ma1uta.matrix.bot.BotDao;
import io.github.ma1uta.matrix.bot.BotState;
import io.github.ma1uta.matrix.bot.Command;
import io.github.ma1uta.matrix.bot.LoopState;
import io.github.ma1uta.matrix.bot.PersistentService;
import io.github.ma1uta.matrix.client.MatrixClient;
import io.github.ma1uta.matrix.client.factory.RequestFactory;
import io.github.ma1uta.matrix.client.model.sync.InvitedRoom;
import io.github.ma1uta.matrix.client.model.sync.JoinedRoom;
import io.github.ma1uta.matrix.client.model.sync.Rooms;
import io.github.ma1uta.matrix.client.model.sync.SyncResponse;
import io.github.ma1uta.matrix.event.Event;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneBot<C extends BotConfig, D extends BotDao<C>, S extends PersistentService<D>, E>
extends Bot<C, D, S, E>
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneBot.class);

    public StandaloneBot(RequestFactory factory, boolean exitOnEmptyRooms, C config, S service, List<Class<? extends Command<C, D, S, E>>> commandsClasses) {
        super(factory, null, exitOnEmptyRooms, config, service, commandsClasses);
    }

    @Override
    public void run() {
        try {
            this.init();
            LoopState state = LoopState.RUN;
            block11: while (!LoopState.EXIT.equals((Object)state)) {
                switch (((BotConfig)this.getContext().getConfig()).getState()) {
                    case NEW: {
                        state = this.newState();
                        continue block11;
                    }
                    case REGISTERED: {
                        state = this.registeredState();
                        continue block11;
                    }
                    case JOINED: {
                        state = this.joinedState();
                        continue block11;
                    }
                    case DELETED: {
                        state = this.deletedState();
                        continue block11;
                    }
                }
                LOGGER.error("Unknown state: " + (Object)((Object)((BotConfig)this.getContext().getConfig()).getState()));
            }
        }
        catch (Throwable e) {
            LOGGER.error("Exception:", e);
            throw e;
        }
        finally {
            this.getContext().getShutdownListeners().forEach(Supplier::get);
        }
    }

    protected LoopState loop(Function<SyncResponse, LoopState> loopAction) {
        Object config = this.getContext().getConfig();
        MatrixClient matrixClient = this.getContext().getMatrixClient();
        SyncResponse sync = (SyncResponse)matrixClient.sync().sync(((BotConfig)config).getFilterId(), ((BotConfig)config).getNextBatch(), false, null, null).join();
        String initialBatch = sync.getNextBatch();
        if (((BotConfig)config).getNextBatch() == null && ((BotConfig)config).getSkipInitialSync() != null && ((BotConfig)config).getSkipInitialSync().booleanValue()) {
            this.getContext().runInTransaction((context, dao) -> ((BotConfig)context.getConfig()).setNextBatch(initialBatch));
            sync = (SyncResponse)matrixClient.sync().sync(((BotConfig)config).getFilterId(), initialBatch, false, null, ((BotConfig)config).getTimeout()).join();
        }
        while (true) {
            try {
                while (true) {
                    LoopState nextState = loopAction.apply(sync);
                    String nextBatch = sync.getNextBatch();
                    this.getContext().runInTransaction((context, dao) -> ((BotConfig)context.getConfig()).setNextBatch(nextBatch));
                    if (LoopState.NEXT_STATE.equals((Object)nextState)) {
                        return LoopState.NEXT_STATE;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        return LoopState.EXIT;
                    }
                    sync = (SyncResponse)matrixClient.sync().sync(((BotConfig)config).getFilterId(), nextBatch, false, null, ((BotConfig)config).getTimeout()).join();
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception: ", (Throwable)e);
                continue;
            }
            break;
        }
    }

    protected LoopState registeredState() {
        return this.loop(sync -> {
            Map invite = sync.getRooms().getInvite();
            HashMap<String, List<Event>> eventMap = new HashMap<String, List<Event>>();
            for (Map.Entry entry : invite.entrySet()) {
                eventMap.put((String)entry.getKey(), ((InvitedRoom)entry.getValue()).getInviteState().getEvents());
            }
            return this.registeredState(eventMap);
        });
    }

    protected LoopState joinedState() {
        return this.loop(sync -> {
            Rooms rooms = sync.getRooms();
            MatrixClient matrixClient = this.getContext().getMatrixClient();
            List joinedRooms = (List)matrixClient.room().joinedRooms().join();
            for (Map.Entry roomEntry : rooms.getLeave().entrySet()) {
                String leftRoom = (String)roomEntry.getKey();
                if (!joinedRooms.contains(leftRoom)) continue;
                matrixClient.room().leave(leftRoom);
            }
            LoopState nextState = LoopState.RUN;
            for (Map.Entry joinedRoomEntry : rooms.getJoin().entrySet()) {
                LoopState state = this.processJoinedRoom((String)joinedRoomEntry.getKey(), ((JoinedRoom)joinedRoomEntry.getValue()).getTimeline().getEvents());
                switch (state) {
                    case EXIT: {
                        nextState = LoopState.EXIT;
                        break;
                    }
                    case NEXT_STATE: {
                        if (LoopState.EXIT.equals((Object)nextState)) break;
                        nextState = LoopState.NEXT_STATE;
                        break;
                    }
                }
            }
            if (((List)this.getContext().getMatrixClient().room().joinedRooms().join()).isEmpty()) {
                this.getContext().runInTransaction((context, dao) -> ((BotConfig)context.getConfig()).setState(this.isExitOnEmptyRooms() ? BotState.DELETED : BotState.REGISTERED));
                return LoopState.NEXT_STATE;
            }
            return nextState;
        });
    }
}

