/*
 * Decompiled with CFR 0.152.
 */
package io.github.ma1uta.matrix.application.api;

import io.github.ma1uta.matrix.EmptyResponse;
import io.github.ma1uta.matrix.Secured;
import io.github.ma1uta.matrix.application.model.RoomVisibility;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;

@Api(value="RoomService", description="Application services can maintain their own room directories for their defined third party protocols. These room directories may be accessed by clients through additional parameters on the /publicRooms client-server endpoint.")
@Path(value="/_matrix/client/r0/directory/list/appservice")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface RoomServiceApi {
    @ApiOperation(value="Updates the visibility of a given room on the application service's room directory.", notes="This API is similar to the room directory visibility API used by clients to update the homeserver's more general room directory.\nThis API requires the use of an application service access token (as_token) instead of a typical client's access_token. This API cannot be invoked by users who are not identified as application services.", response=EmptyResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="The room's directory visibility has been updated.")})
    @Secured
    @PUT
    @Path(value="/{networkId}/{roomId}")
    public void updateVisibility(@PathParam(value="networkId") String var1, @PathParam(value="roomId") String var2, RoomVisibility var3, @Context HttpServletRequest var4, @Suspended AsyncResponse var5);

    public static class Visibility {
        public static final String PUBLIC = "public";
        public static final String PRIVATE = "private";

        protected Visibility() {
        }
    }
}

